package eu.javaexperience.web.server.commons;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.io.IOStream;
import eu.javaexperience.io.fd.IOStreamFactory;
import eu.javaexperience.web.server.binding.HttpQueryContext;
import eu.javaexperience.web.server.binding.HttpServingTimeMetric;
import eu.javaexperience.web.server.binding.HttpSocketProtocol;
import eu.javaexperience.web.server.binding.HttpSocketProtocolHandler;
import eu.javaexperience.web.server.lightning.protocol.InternalHttpProtocol;
import eu.javaexperience.web.server.lightningImpl.LightningHttpQueryContext;

public class LightningTools
{
	public static HttpQueryContext createNewDummyReduestWithSession
	(
		String requestUrl,
		InputStream is,
		OutputStream os,
		Map<String, String> reqHeader,
		String method
	)
		throws MalformedURLException, IOException
	{
		InternalHttpProtocol http = new InternalHttpProtocol(IOStreamFactory.fromInAndOutputStream(is, os), new URL(requestUrl), method, reqHeader);
		http.initRequest();
		LightningHttpQueryContext query = new LightningHttpQueryContext(http);
		return query;
	}
	
	public static LightningHttpQueryContext handleRequest(HttpSocketProtocol protocol, IOStream socket, SimplePublish1<LightningHttpQueryContext> requestHandler) throws IOException
	{
		long t0 = System.currentTimeMillis();
		HttpSocketProtocolHandler protocolHandler = protocol.createQuery(socket);
		protocolHandler.initRequest();
		LightningHttpQueryContext ssrr = new LightningHttpQueryContext(protocolHandler);//TODO az ugyanolyan ip-jűket elrakjuk
		ssrr.setTimeMetric(HttpServingTimeMetric.RequestStart, t0);
		
		if(true)
			protocolHandler.handlePosts(ssrr.request);
		ssrr.setTimeMetric(HttpServingTimeMetric.RequestParse, System.currentTimeMillis());
		
		requestHandler.publish(ssrr);
		
		ssrr.operationEnded();
		
		ssrr.flush();
		ssrr.setTimeMetric(HttpServingTimeMetric.Finish, System.currentTimeMillis());
		
		//keep alive, felszabadítjuk ami a kéréshez tarozik,
		//de a kapcsolatot nem zárjuk be
		protocolHandler.finishTransmission(ssrr.getLightningOutput());
		
		return ssrr;
	}
}
