package eu.javaexperience.web.server.example;

import java.io.IOException;
import java.net.ServerSocket;

import eu.javaexperience.io.IOStream;
import eu.javaexperience.io.fd.IOStreamFactory;
import eu.javaexperience.web.server.binding.WellKnownSocketHttpProtocol;
import eu.javaexperience.web.server.commons.Lightning;

public class LightningExample
{
	public static void main(String[] args) throws IOException
	{
		ExampleServlet ex = new ExampleServlet();
		Lightning<IOStream> srv = new Lightning<IOStream>
		(
			IOStreamFactory.fromServerSocket(new ServerSocket(8080)),
			WellKnownSocketHttpProtocol.RAW_HTTP,
			10,
			ex
		);
		
		srv.setKeepAlive(false);
		srv.setMaxConnectionPerIp(-1);
		
		srv.start();
	}
}
