package eu.javaexperience.web.server.lightning.protocol;

import java.io.IOException;
import java.net.URL;
import java.util.Map;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.collection.map.NullMap;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.io.IOStream;
import eu.javaexperience.web.dispatch.url.PreparedURL;
import eu.javaexperience.web.server.binding.WellKnownSocketHttpProtocol;
import eu.javaexperience.web.server.commons.AbstractHttpProtocolHandler;
import eu.javaexperience.web.server.commons.LightningOutput;

public class InternalHttpProtocol extends AbstractHttpProtocolHandler
{
	protected final PreparedURL requestUrl;
	protected final String method;
	protected final Map<String, String> requestHeaders;
	
	public InternalHttpProtocol(IOStream stream, URL url, String method, Map<String,String> headers)
	{
		super(stream, WellKnownSocketHttpProtocol.INTERNAL);
		this.requestUrl = new PreparedURL(url);
		AssertArgument.assertNotNull(this.method = method, "request method");
		this.requestHeaders = null == headers?NullMap.instance:headers;
	}
	
	protected int returnStatus = 200;
	protected String returnStatusText = "OK";
	protected Map<String, String> returnHeaders;
	
	@Override
	public void sendResponseHeaders
	(
		LightningOutput os,
		int responseStatus,
		String responseStatusText,
		Map<String, String> send
	)
		throws IOException
	{
		this.returnStatus = responseStatus;
		this.returnStatusText = responseStatusText;
		this.returnHeaders = new SmallMap<>(send);
	}

	@Override
	public void finishTransmission(LightningOutput os) throws IOException
	{
		
	}

	@Override
	protected IOStream initSocketRequest() throws IOException
	{
		setParsedRequestProperties
		(
			requestUrl.getProtocol(),
			method,
			requestUrl.getDomainOnly(),
			String.valueOf(requestUrl.getPort()),
			requestUrl.getUri(),
			requestUrl.getUrl(),
			requestUrl.getQuery(),
			requestHeaders,
			requestUrl.getParams()
		);
		
		return ioStream;
	}

}
