/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.dispatch.Dispatcher;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import eu.javaexperience.io.IOStream;
import eu.javaexperience.io.IOStreamServer;
import eu.javaexperience.io.fd.IOStreamFactory;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.Session;
import eu.javaexperience.web.SessionManager;
import eu.javaexperience.web.TemplateWebsiteContext;
import eu.javaexperience.web.TemplateWebsiteTools;
import eu.javaexperience.web.facility.SiteFacility;
import eu.javaexperience.web.fw.TemplateWebsite;
import eu.javaexperience.web.server.binding.HttpSocketProtocol;
import eu.javaexperience.web.server.binding.WellKnownSocketHttpProtocol;
import eu.javaexperience.web.server.commons.Lightning;
import eu.javaexperience.web.service.hooks.ServiceProcessHooks;
import eu.javaexperience.web.session.InMemorySessionManager;
import eu.javaexperience.web.session.SessionTools;
import eu.javaexperience.web.template.Template;
import eu.javaexperience.web.template.TemplateManager;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Map;

public abstract class TemplateWebsiteServer {
    protected GetBy1<ServiceProcessHooks, ServiceProcessHooks> hookModifier;
    protected static final ServiceProcessHooks HOOKS = new ServiceProcessHooks(){
        SimplePublish1<Context> rightBeforeFinishOperation = new SimplePublish1<Context>(){

            public void publish(Context a) {
                TemplateWebsiteTools.getContextTemplateFw((Context)a).TEMPLATE.hook_rightBeforeFinishOperation(a);
            }
        };
        SimplePublish2<Session, Context> onSessionRefreshLastUse = new SimplePublish2<Session, Context>(){

            public void publish(Session a, Context b) {
                TemplateWebsiteTools.getContextTemplateFw((Context)b).TEMPLATE.hook_onSessionRefreshLastUse(a, b);
            }
        };
        SimplePublish1<Context> beforeRequestDispatchStart = new SimplePublish1<Context>(){

            public void publish(Context a) {
                TemplateWebsiteTools.getContextTemplateFw((Context)a).TEMPLATE.hook_beforeRequestDispatchStart(a);
            }
        };
        SimplePublish1<Context> beforeHeaderSent = new SimplePublish1<Context>(){

            public void publish(Context a) {
                TemplateWebsiteTools.getContextTemplateFw((Context)a).TEMPLATE.hook_beforeHeaderSent(a);
            }
        };
        protected GetBy1<Boolean, Context> apply = new GetBy1<Boolean, Context>(){

            public Boolean getBy(Context ctx) {
                return TemplateWebsiteTools.getContextTemplateFw((Context)ctx).TEMPLATE.hook_applyView(ctx);
            }
        };
        SimplePublish1<Context> afterRequestEnd = new SimplePublish1<Context>(){

            public void publish(Context a) {
                TemplateWebsiteTools.getContextTemplateFw((Context)a).TEMPLATE.hook_afterRequestEnd(a);
            }
        };
        GetBy2<Map<String, Object>, Context, Map<String, Object>> wrapContextForRender = new GetBy2<Map<String, Object>, Context, Map<String, Object>>(){

            public Map<String, Object> getBy(Context ctx, Map<String, Object> a) {
                return TemplateWebsiteTools.getContextTemplateFw((Context)ctx).TEMPLATE.hook_wrapContextForRender(ctx, a);
            }
        };

        public SimplePublish1<Context> rightBeforeFinishOperation() {
            return this.rightBeforeFinishOperation;
        }

        public SimplePublish2<Session, Context> onSessionRefreshLastUse() {
            return this.onSessionRefreshLastUse;
        }

        public SimplePublish1<Context> beforeRequestDispatchStart() {
            return this.beforeRequestDispatchStart;
        }

        public SimplePublish1<Context> beforeHeaderSent() {
            return this.beforeHeaderSent;
        }

        public GetBy1<Boolean, Context> applyView() {
            return this.apply;
        }

        public SimplePublish1<Context> afterRequestEnd() {
            return this.afterRequestEnd;
        }

        public GetBy2<Map<String, Object>, Context, Map<String, Object>> wrapContextForRender() {
            return this.wrapContextForRender;
        }
    };
    public final TemplateWebsiteContext WEB_CTX;
    public final Lightning<IOStream> SERVER;
    protected final Dispatcher<Context> dispatcher;
    public static final String TEMPLATE_WEBSITE_FRAMEWORK_KEY = "SYS_TWFW";

    protected void hook_rightBeforeFinishOperation(Context ctx) {
    }

    protected void hook_onSessionRefreshLastUse(Session a, Context b) {
    }

    protected void hook_beforeRequestDispatchStart(Context ctx) {
    }

    protected void hook_beforeHeaderSent(Context ctx) {
    }

    protected Boolean hook_applyView(Context ctx) {
        Map VIEW;
        Map obj = ctx.getEnv();
        if (null != obj && null != (VIEW = (Map)obj.get("VIEW"))) {
            Object root = VIEW.get("root");
            Template t = null;
            if (root instanceof Template) {
                t = (Template)root;
            } else if (root instanceof String) {
                t = TemplateWebsiteTools.getContextTemplateFw((Context)ctx).WEB_CONTEXT.getView((String)root);
            }
            if (null != t) {
                try {
                    t.render(ctx, (Appendable)ctx.getResponse().getWriter());
                }
                catch (IOException e) {
                    Mirror.propagateAnyway((Throwable)e);
                }
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    protected void unservedRequest(Context ctx) {
    }

    protected void hook_afterRequestEnd(Context ctx) {
    }

    protected Map<String, Object> hook_wrapContextForRender(Context ctx, Map<String, Object> env) {
        return env;
    }

    protected void hook_exceptionProcess(Context ctx) {
        Throwable t = ctx.getProcessException();
        if (null != t) {
            ctx.getEnv().put("exception", t);
        }
    }

    protected SiteFacility.SiteObjectSettings generateConfiguration() {
        SiteFacility.SiteObjectSettings ret = new SiteFacility.SiteObjectSettings();
        ret.sessionCookieName = "jvx-session";
        ret.sessionManager = this.createSessionManager();
        ret.templateManager = this.createDefaultTemplateManager();
        ServiceProcessHooks hooks = HOOKS;
        if (null != this.hookModifier) {
            hooks = (ServiceProcessHooks)this.hookModifier.getBy((Object)hooks);
        }
        ret.createContext = TemplateWebsiteTools.generateContextCreatorWithHooks(hooks);
        ret.beforeRequestProcess = new SimplePublish1<Context>(){

            public void publish(Context ctx) {
                TemplateWebsiteServer.this.initRequest(ctx);
            }
        };
        ret.beforeViewApply = TemplateWebsite.beforeViewApplyLightningLogTemplateCompilationStartTime;
        ret.afterRequestEnd = TemplateWebsite.logAfterRequestEnd((SimpleGet<? extends Appendable>)new SimpleGet<Appendable>(){

            public Appendable get() {
                return System.out;
            }
        });
        ret.exceptionHandler = new SimplePublish1<Context>(){

            public void publish(Context ctx) {
                TemplateWebsiteServer.this.hook_exceptionProcess(ctx);
            }
        };
        ret.unserved = new SimplePublish1<Context>(){

            public void publish(Context a) {
                TemplateWebsiteServer.this.unservedRequest(a);
            }
        };
        return ret;
    }

    protected SessionManager createSessionManager() {
        return new InMemorySessionManager();
    }

    protected IOStreamServer getWebServerSocket() throws IOException {
        return IOStreamFactory.fromServerSocket((ServerSocket)new ServerSocket(5555));
    }

    protected void addDispatchers(SiteFacility WEB_CONTEXT, Dispatcher<Context> dispatch) {
        WEB_CONTEXT.addRootDispatcher(dispatch);
    }

    public Dispatcher<Context> getDispatcher() {
        return this.dispatcher;
    }

    public TemplateWebsiteServer(Dispatcher<Context> dispatcher) throws IOException {
        SiteFacility WEB_CONTEXT = new SiteFacility(this.generateConfiguration());
        this.dispatcher = dispatcher;
        this.addDispatchers(WEB_CONTEXT, dispatcher);
        this.SERVER = new Lightning(this.getWebServerSocket(), this.getHttpProtocol(), 10, WEB_CONTEXT);
        this.SERVER.setKeepAlive(false);
        this.SERVER.setMaxConnectionPerIp(0);
        this.WEB_CTX = new TemplateWebsiteContext(this.SERVER, WEB_CONTEXT, this);
    }

    public HttpSocketProtocol getHttpProtocol() {
        return WellKnownSocketHttpProtocol.RAW_HTTP;
    }

    public String getSessionCookieName() {
        return this.WEB_CTX.getWebContext().getSessionCookieName();
    }

    public abstract TemplateManager createDefaultTemplateManager();

    public boolean needSessionStart(Context ctx) {
        return true;
    }

    public void initRequest(Context ctx) {
        SessionManager sm;
        Map ENV = ctx.getEnv();
        ENV.put(TEMPLATE_WEBSITE_FRAMEWORK_KEY, this.WEB_CTX);
        if (this.needSessionStart(ctx) && null != (sm = this.WEB_CTX.WEB_CONTEXT.getSessionManager())) {
            SessionTools.sessionStart((SessionManager)sm, (String)this.getSessionCookieName(), (Context)ctx);
        }
        ENV.put("VIEW", new SmallMap());
    }

    public void start() {
        this.WEB_CTX.SERVER.start();
    }
}

