/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web;

import eu.javaexperience.arrays.ArrayTools;
import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.collection.NullCollection;
import eu.javaexperience.collection.list.PrettyPrintArrayList;
import eu.javaexperience.collection.map.KeyVal;
import eu.javaexperience.collection.map.MapTools;
import eu.javaexperience.dispatch.Dispatcher;
import eu.javaexperience.file.AbstractFile;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.getBy.GetBy3;
import eu.javaexperience.io.IOStream;
import eu.javaexperience.io.IOStreamServer;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.patterns.behavioral.cor.link.CorChainLink;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.text.Format;
import eu.javaexperience.text.StringTools;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.MIME;
import eu.javaexperience.web.RequestContext;
import eu.javaexperience.web.TemplateWebsiteContext;
import eu.javaexperience.web.TemplateWebsiteDefaultAsset;
import eu.javaexperience.web.TemplateWebsiteServer;
import eu.javaexperience.web.dispatch.DefaultDispatchStructure;
import eu.javaexperience.web.dispatch.WebDispatchTools;
import eu.javaexperience.web.dispatch.url.AttachDirectoryURLNode;
import eu.javaexperience.web.facility.SiteFacility;
import eu.javaexperience.web.facility.SiteFacilityTools;
import eu.javaexperience.web.service.hooks.ServiceProcessHooks;
import eu.javaexperience.web.template.Template;
import eu.javaexperience.web.template.TemplateManager;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TemplateWebsiteTools {
    protected static final SimpleGet<PrettyPrintArrayList> PRETTY_PRINT_LIST = new SimpleGet<PrettyPrintArrayList>(){

        public PrettyPrintArrayList get() {
            return new PrettyPrintArrayList(PrettyPrintArrayList.PRINT_CONTENT_ONLY_UNSEPARATED);
        }
    };
    public static final String RESOURCE_DIR = "/home/szupervigyor/projektek/web";

    public static TemplateWebsiteContext getContextTemplateFw(Context ctx) {
        TemplateWebsiteContext ret = (TemplateWebsiteContext)ctx.getEnv().get("SYS_TWFW");
        if (null == ret) {
            throw new RuntimeException("TemplateWebsiteContext not found in context. Do you forget to call super.initRequest when you have overriden in TemplateWebsiteServer?");
        }
        return ret;
    }

    public static void addView(Context ctx, String name, String view) {
        Map map = MapTools.ensureSmallMapKey((Map)ctx.getEnv(), (Object)"VIEW");
        Object o = map.get(name);
        map.put(name, CollectionTools.addOrWrap(o, PRETTY_PRINT_LIST, (Object)TemplateWebsiteTools.getTemplate(ctx, view)));
    }

    public static Template getTemplate(Context ctx, String name) {
        return TemplateWebsiteTools.getContextTemplateFw((Context)ctx).WEB_CONTEXT.getView(name);
    }

    public static void addViewElement(Context ctx, String name, Object subject) {
        Map map = MapTools.ensureSmallMapKey((Map)ctx.getEnv(), (Object)"VIEW");
        Object o = map.get(name);
        map.put(name, CollectionTools.addOrWrap(o, PRETTY_PRINT_LIST, (Object)subject));
    }

    public static Collection getViewVarAsCollection(Context ctx, String name) {
        Map map = MapTools.ensureSmallMapKey((Map)ctx.getEnv(), (Object)"VIEW");
        Object o = map.get(name);
        Collection ret = CollectionTools.addOrWrap(o, PRETTY_PRINT_LIST, null);
        map.put(name, ret);
        return ret;
    }

    public static void exportTemplatePackage(Collection<ExportTemplate> coll, String templateDir, String _package, String extension) {
        File f = new File(StringTools.toString((Object)(templateDir + "/" + _package)));
        String[] fs = f.list();
        if (null != fs) {
            String ext = "." + extension;
            for (String t : fs) {
                coll.add(new ExportTemplate(templateDir, _package + "/" + StringTools.getSubstringBeforeFirstString((String)t, (String)ext, (String)t), extension));
            }
        }
    }

    public static void addViewAndFinish(Context ctx, String name, String view) {
        TemplateWebsiteTools.addView(ctx, name, view);
        SiteFacilityTools.finishWithRender((Context)ctx);
    }

    public static void addResource(Context ctx, String resourceType, String resourceUrl) {
        Map map = MapTools.ensureSmallMapKey((Map)ctx.getEnv(), (Object)"RESOURCE");
        Object[] arr = (Object[])map.get(resourceType);
        map.put(resourceType, ArrayTools.arrayAppendOrCreate((Object[])arr, (Object)resourceUrl));
    }

    public static void setView(Context ctx, String name, String view) {
        TemplateWebsiteContext TWFW = TemplateWebsiteTools.getContextTemplateFw(ctx);
        MapTools.ensureSmallMapKey((Map)ctx.getEnv(), (Object)"VIEW").put(name, TWFW.WEB_CONTEXT.getView(view));
    }

    public static GetBy3<? extends Context, SiteFacility, HttpServletRequest, HttpServletResponse> generateContextCreatorWithHooks(final ServiceProcessHooks hooks) {
        return new GetBy3<Context, SiteFacility, HttpServletRequest, HttpServletResponse>(){

            public Context getBy(SiteFacility a, HttpServletRequest b, HttpServletResponse c) {
                RequestContext ctx = new RequestContext(b, c);
                ctx.setServiceProcessHooks(hooks);
                return ctx;
            }
        };
    }

    public static TemplateWebsiteServer createTemplateServer(Dispatcher<Context> dispatcher, final SimpleGet<IOStreamServer<IOStream>> serverSocketCreator, TemplateWebsiteDefaultAsset assets, AbstractFile TEMPLATE_ROOT, final TemplateWebsiteTemplateDetails templateDetails) {
        TemplateWebsiteServer srv = null;
        try {
            srv = new TemplateWebsiteServer(dispatcher){

                @Override
                public TemplateManager createDefaultTemplateManager() {
                    if (null != templateDetails) {
                        return templateDetails.createDefaultTemplateManager();
                    }
                    return new TemplateManager(){

                        public Collection<String> getViews() {
                            return NullCollection.INSTANCE;
                        }

                        public Template getView(String label) {
                            return null;
                        }
                    };
                }

                @Override
                protected Boolean hook_applyView(Context ctx) {
                    try {
                        if (null != templateDetails) {
                            templateDetails.applyView(ctx);
                        }
                    }
                    catch (Exception e) {
                        Mirror.propagateAnyway((Throwable)e);
                    }
                    return true;
                }

                @Override
                public void initRequest(Context ctx) {
                    super.initRequest(ctx);
                    if (null != templateDetails) {
                        templateDetails.initRequest(ctx);
                    }
                }

                @Override
                protected IOStreamServer getWebServerSocket() throws IOException {
                    return (IOStreamServer)serverSocketCreator.get();
                }

                @Override
                protected void hook_exceptionProcess(Context ctx) {
                    super.hook_exceptionProcess(ctx);
                    ctx.getResponse().setStatus(500);
                    SiteFacilityTools.finishWithMimeSend((Context)ctx, (String)Format.getPrintedStackTrace((Throwable)((Throwable)ctx.getEnv().get("exception"))), (MIME)MIME.plain);
                }

                @Override
                protected void unservedRequest(Context ctx) {
                    ctx.getResponse().setStatus(404);
                    super.unservedRequest(ctx);
                }
            };
        }
        catch (Exception e) {
            Mirror.propagateAnyway((Throwable)e);
        }
        return srv;
    }

    public static void addResourceDisaptcher(DefaultDispatchStructure dds) {
        TemplateWebsiteTools.attachResource(dds, "resource", RESOURCE_DIR);
    }

    public static void attachResource(DefaultDispatchStructure dds, String rootPath, String f) {
        dds.getChains().getChainByName("static").addLink((CorChainLink)WebDispatchTools.createWithPathNodeStart((Map.Entry[])new Map.Entry[]{new KeyVal((Object)rootPath, (Object)new AttachDirectoryURLNode("", f, true))}));
    }

    public static interface TemplateWebsiteTemplateDetails {
        public TemplateManager createDefaultTemplateManager();

        public void applyView(Context var1) throws Exception;

        public void initRequest(Context var1);
    }

    public static class ExportTemplate {
        protected String rootDir;
        protected String name;
        protected String extension;

        public ExportTemplate(String rootDir, String name, String extension) {
            this.rootDir = rootDir;
            this.name = name;
            this.extension = extension;
        }

        public String getContent() throws IOException {
            return IOTools.getFileContents((String)this.getFile());
        }

        public String getName() {
            return this.name;
        }

        public String getFile() {
            return this.rootDir + "/" + this.name + "." + this.extension;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("<script type=\"x-tmpl-mustache\" data-template=\"" + this.name + "\">\n");
            try {
                sb.append(this.getContent());
            }
            catch (Exception e) {
                sb.append(this.formatException(e));
            }
            sb.append("</script>");
            return sb.toString();
        }

        public String formatException(Throwable e) {
            StringBuilder sb = new StringBuilder();
            sb.append("<pre>");
            sb.append("Can't read template: ");
            sb.append("\n");
            sb.append(Format.getPrintedStackTrace((Throwable)e));
            sb.append("</pre>");
            return sb.toString();
        }
    }
}

