/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.elements;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.io.ToAppendable;
import eu.javaexperience.web.elements.HElementRenderModifier;
import eu.javaexperience.web.elements.HElementTools;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class HElement
implements Iterable<HElement>,
Serializable,
ToAppendable {
    private static final long serialVersionUID = -9119947808135670134L;
    public final String tagName;
    protected List<HElement> moreElements = new ArrayList<HElement>();
    protected String text;
    protected SmallMap<String, String> attributes = new SmallMap();
    protected HElementRenderModifier modder;
    public static final HElement[] emptyhearr = new HElement[0];
    protected static String lvl = "\t";
    protected static String eol = "\n";
    private static final Iterator<HElement> nullIterator = new Iterator<HElement>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public HElement next() {
            return null;
        }

        @Override
        public void remove() {
        }
    };

    public boolean isJelolo() {
        return false;
    }

    protected HElement(String tagName, Object IGNORED) {
        this.tagName = tagName;
    }

    public HElement(PrototypeTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException("A TAG enum nem lehet null");
        }
        this.tagName = tag.getTagName();
    }

    public HElement(String tagNev) {
        if (tagNev == null) {
            throw new IllegalArgumentException("A TAG neve nem lehet null");
        }
        if (!Pattern.matches("!?[a-z]+[a-z0-9]*", tagNev = tagNev.toLowerCase())) {
            throw new IllegalArgumentException(tagNev + " \u00e9rv\u00e9nytelen tag n\u00e9v");
        }
        this.tagName = tagNev;
    }

    public boolean hasAttribute(String attr) {
        if (attr == null) {
            return false;
        }
        return this.attributes.get((Object)attr) != null;
    }

    public String getAttribute(String attr) {
        return (String)this.attributes.get((Object)attr);
    }

    public HElement addAttribute(String key, String value) {
        if (key != null) {
            this.attributes.put((Object)key, (Object)value);
        }
        return this;
    }

    public HElement addNotNullValueAttribute(String key, String value) {
        if (key != null && null != value) {
            this.attributes.put((Object)key, (Object)value);
        }
        return this;
    }

    public HElement glueToAttribute(String key, String glue, String value) {
        if (key != null && null != value) {
            String in = (String)this.attributes.get((Object)key);
            if (null == in) {
                this.attributes.put((Object)key, (Object)value);
            } else {
                this.attributes.put((Object)key, (Object)(in + glue + value));
            }
        }
        return this;
    }

    public HElement delAttribute(String key) {
        this.attributes.remove((Object)key);
        return this;
    }

    public HElement appendAttributeString(String key, String appendVal) {
        if (appendVal == null || key == null) {
            return this;
        }
        String val = (String)this.attributes.get((Object)key);
        if (val == null) {
            this.attributes.put((Object)key, (Object)appendVal);
            return this;
        }
        val = val + appendVal;
        this.attributes.put((Object)key, (Object)appendVal);
        return this;
    }

    public HElement appendAttributeStrings(String key, String ... appendVal) {
        if (appendVal == null) {
            return this;
        }
        if (appendVal.length == 0) {
            return this;
        }
        if (appendVal.length == 1) {
            this.appendAttributeString(key, appendVal[0]);
            return this;
        }
        StringBuilder sb = new StringBuilder();
        String inital = (String)this.attributes.get((Object)key);
        if (key != null) {
            sb.append(inital);
        }
        for (int i = 0; i < appendVal.length; ++i) {
            if (appendVal[i] == null) continue;
            sb.append(appendVal[i]);
        }
        this.attributes.put((Object)key, (Object)sb.toString());
        return this;
    }

    public HElement unsetChild(int i) {
        this.moreElements.remove(i);
        return this;
    }

    public HElement appendAttributeStringsSeparatedBy(String key, String sepatator, String ... appendVal) {
        if (appendVal == null) {
            return this;
        }
        if (appendVal.length == 0) {
            return this;
        }
        if (appendVal.length == 1) {
            this.appendAttributeStrings(key, sepatator, appendVal[0]);
            return this;
        }
        StringBuilder sb = new StringBuilder();
        String inital = (String)this.attributes.get((Object)key);
        if (key != null) {
            sb.append(inital);
            sb.append(sepatator);
        }
        for (int i = 0; i < appendVal.length; ++i) {
            if (appendVal[i] == null) continue;
            sb.append(appendVal[i]);
            if (i == appendVal.length - 1) continue;
            sb.append(sepatator);
        }
        this.attributes.put((Object)key, (Object)sb.toString());
        return this;
    }

    public Iterable<Map.Entry<String, String>> getAttrs() {
        return this.attributes.entrySet();
    }

    public HElement setRenderModifier(HElementRenderModifier modder) {
        this.modder = modder;
        return this;
    }

    public HElementRenderModifier getRenderModifier(HElementRenderModifier modder) {
        return modder;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            this.append(sb);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public boolean hasCloseTag() {
        if (this.tagName == null) {
            return false;
        }
        return this.tagName.charAt(0) != '!';
    }

    public void append(Appendable app) throws IOException {
        this.append(app, "", lvl, eol);
    }

    public void append(Appendable app, String crnt, String lvl1, String EOL) throws IOException {
        boolean notJustText;
        if (this.modder != null && !this.modder.beforeStartTagAppend(this, app, crnt, lvl1, EOL)) {
            return;
        }
        if (crnt != null) {
            app.append(crnt);
        }
        if (this.tagName != null) {
            app.append('<');
            app.append(this.tagName);
            if (this.attributes.size() > 0) {
                Iterator it = this.attributes.getKeyIterator().iterator();
                String key = null;
                while (it.hasNext()) {
                    key = (String)it.next();
                    app.append(' ');
                    app.append(key);
                    String val = (String)this.attributes.get((Object)key);
                    if (val == null) continue;
                    app.append("=\"");
                    app.append(val);
                    app.append('\"');
                }
            }
        }
        boolean hasCloseTag = this.hasCloseTag();
        boolean bl = notJustText = this.moreElements.size() > 0 && crnt != null;
        if (this.moreElements.size() == 0 && hasCloseTag && this.text == null) {
            app.append("/>");
            if (crnt != null) {
                app.append(EOL);
            }
            return;
        }
        if (this.tagName != null) {
            app.append(">");
        }
        if (notJustText) {
            app.append(EOL);
        }
        if (this.modder != null) {
            this.modder.beforeTextAppend(this, app);
        }
        if (this.text != null) {
            app.append(this.text);
        }
        if (this.modder != null) {
            this.modder.beforeSubelementsAppend(this, app);
        }
        if (crnt == null) {
            for (HElement e : this.moreElements) {
                e.append(app);
            }
        } else {
            String nxt = crnt == null ? null : crnt + lvl1;
            for (HElement e : this.moreElements) {
                e.append(app, nxt, lvl1, EOL);
            }
        }
        if (this.modder != null) {
            this.modder.beforeEndTagAppend(this, app);
        }
        if (hasCloseTag) {
            if (notJustText) {
                app.append(crnt);
            }
            app.append("</");
            app.append(this.tagName);
            app.append(">");
        }
        if (crnt != null) {
            app.append(EOL);
        }
        if (this.modder != null) {
            this.modder.afterCloseTagAppend(this, app);
        }
    }

    public HElement addHElements(HElement ... elems) {
        if (elems == null) {
            return this;
        }
        for (int i = 0; i < elems.length; ++i) {
            if (elems[i] == null) continue;
            this.moreElements.add(elems[i]);
        }
        return this;
    }

    public HElement addHElements(Collection<HElement> elems) {
        if (elems == null) {
            return this;
        }
        for (HElement e : elems) {
            if (e == null) continue;
            this.moreElements.add(e);
        }
        return this;
    }

    public HElement addHElements(HElement elems) {
        if (elems != null) {
            this.moreElements.add(elems);
        }
        return this;
    }

    public int sizeSubElements() {
        return this.moreElements.size();
    }

    public HElement[] getAllSubElements() {
        if (this.moreElements == null) {
            return new HElement[]{this};
        }
        ArrayList<HElement> elemz = new ArrayList<HElement>();
        this.getAllSubElements(elemz);
        return elemz.toArray(emptyhearr);
    }

    protected void getAllSubElements(ArrayList<HElement> elemz) {
        elemz.add(this);
        if (this.moreElements == null) {
            return;
        }
        for (HElement e : this.moreElements) {
            if (elemz.contains(e)) continue;
            e.getAllSubElements(elemz);
        }
    }

    public boolean hasHElements(HElement ... elems) {
        if (this.moreElements == null || elems == null) {
            return false;
        }
        for (int i = 0; i < elems.length; ++i) {
            if (elems[i] == null || this.moreElements.contains(elems[i])) continue;
            return false;
        }
        return true;
    }

    public HElement delHElements(HElement ... elems) {
        if (this.moreElements == null || elems == null) {
            return this;
        }
        for (int i = 0; i < elems.length; ++i) {
            if (elems[i] == null || this.moreElements.contains(elems[i])) continue;
            this.moreElements.add(elems[i]);
        }
        return this;
    }

    public HElement setHElements(HElement ... elems) {
        if (this.moreElements == null || elems == null) {
            return this;
        }
        this.moreElements.clear();
        return this.addHElements(elems);
    }

    public HElement unsetChilds() {
        this.moreElements.clear();
        return this;
    }

    public HElement setText(String str) {
        this.text = str;
        return this;
    }

    public HElement appendText(String ... strs) {
        if (strs == null) {
            return this;
        }
        StringBuilder sb = new StringBuilder();
        if (this.text != null) {
            sb.append(this.text);
        }
        for (int i = 0; i < strs.length; ++i) {
            if (strs[i] == null) continue;
            sb.append(strs[i]);
        }
        this.text = sb.toString();
        return this;
    }

    public String getText() {
        return this.text;
    }

    public HElement topLvlClone() {
        HElement ret = new HElement(this.tagName, null);
        ret.text = this.text;
        ret.attributes = this.attributes.clone();
        ret.modder = this.modder;
        return ret;
    }

    public HElement deepClone() {
        HElement ret = new HElement(this.tagName, null);
        ret.text = this.text;
        if (this.attributes != null) {
            ret.attributes = new SmallMap();
            if (this.attributes.size() > 0) {
                for (Map.Entry ss : this.attributes.entrySet()) {
                    ret.attributes.put(ss.getKey(), ss.getValue());
                }
            }
        }
        if (this.moreElements != null) {
            for (HElement e : this.moreElements) {
                ret.addHElements(e.deepClone());
            }
        }
        return ret;
    }

    public HElement directCloneAs(String tagName) {
        HElement ret = new HElement(tagName, null);
        ret.text = this.text;
        if (this.attributes != null) {
            ret.attributes = this.attributes.clone();
        }
        if (this.moreElements != null) {
            ret.addHElements(this.moreElements.toArray(emptyhearr));
        }
        return ret;
    }

    public boolean hasMoreHElements() {
        if (this.moreElements != null) {
            return this.moreElements.size() > 0;
        }
        return false;
    }

    public HElement slider(int min, int max, SliderSelectType seltype, SliderOrientation oritype, int start1, int start2) {
        if (seltype == null) {
            throw new IllegalArgumentException("A kiv\u00e1laszt\u00e1s t\u00edpusa nem lehet null!");
        }
        if (oritype == null) {
            throw new IllegalArgumentException("A elrendez\u00e9s t\u00edpusa nem lehet null!");
        }
        this.addAttribute("class", "EXEC");
        this.addAttribute("data-exec", "{'action':'regSlider','min':" + min + ",'max':" + max + ",'ori':" + oritype.ordinal() + ",'sel':" + seltype.ordinal() + ",'s1':" + start1 + ",'s2':" + start2 + "}");
        return this;
    }

    public List<HElement> getDirectSubelements() {
        return this.moreElements;
    }

    public HElement draggable() {
        this.addAttribute("class", "LFDA");
        return this;
    }

    public HElement droppable() {
        this.addAttribute("class", "LFDO");
        return this;
    }

    public HElement sortable() {
        this.addAttribute("class", "SORT");
        return this;
    }

    @Override
    public Iterator<HElement> iterator() {
        if (this.moreElements == null) {
            return nullIterator;
        }
        return new Iterator<HElement>(){
            int it = 0;

            @Override
            public boolean hasNext() {
                return this.it < HElement.this.moreElements.size();
            }

            @Override
            public HElement next() {
                return HElement.this.moreElements.get(this.it++);
            }

            @Override
            public void remove() {
                HElement.this.moreElements.remove(this.it - 1);
            }
        };
    }

    public HElement getElementById(String id) {
        return HElementTools.findElementById(this, id);
    }

    public void addFirstChild(HElement e) {
        if (null != e) {
            this.moreElements.add(0, e);
        }
    }

    public void applyOnTree(SimplePublish1<HElement> modifier) {
        modifier.publish((Object)this);
        for (HElement c : this.moreElements) {
            c.applyOnTree(modifier);
        }
    }

    public static enum SliderOrientation {
        horizontal,
        vertical;

    }

    public static enum SliderSelectType {
        value,
        range;

    }

    public static class SimpleTag
    implements PrototypeTag {
        private final String name;

        public SimpleTag(String name) {
            this.name = new HElement((String)name).tagName;
        }

        @Override
        public String getTagName() {
            return this.name;
        }
    }

    public static interface PrototypeTag {
        public String getTagName();
    }
}

