/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.elements;

import eu.javaexperience.collection.map.BulkTransitMap;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.text.StringTools;
import eu.javaexperience.web.elements.ClonePageFactory;
import eu.javaexperience.web.elements.ClonedPage;
import eu.javaexperience.web.elements.HElement;
import eu.javaexperience.web.elements.HtmlPart;
import eu.javaexperience.web.elements.SaxHElementParser;
import eu.javaexperience.web.elements.Tag;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class HElementTools {
    public static final String head = "head";
    public static final String title = "title";
    public static final String body = "body";
    private static final ClonePageFactory basic = new ClonePageFactory(Tag.doctypeHtml.newInstance().addHElements(Tag.html.newInstance().addHElements(new HtmlPart("head").addHElements(Tag.head.newInstance().addHElements(Tag.meta.newInstance().addAttribute("charset", "utf-8"), new HtmlPart("title").addHElements(Tag.title.newInstance()))), new HtmlPart("body").addHElements(Tag.body.newInstance()))));
    protected static final BulkTransitMap<String, String> HTML_REPLACE = new BulkTransitMap();

    public static HElement parse(String content) throws SAXException, IOException, ParserConfigurationException {
        return SaxHElementParser.parseHtmlSax(content);
    }

    public static HElement formHiddenParameter(String method, @MayNull String action, String varName, String varValue, String buttonLabel) {
        HElement ret = Tag.form.newInstance().addAttribute("method", method);
        if (action != null) {
            ret.addAttribute("action", action);
        }
        ret.addHElements(Tag.input.newInstance().addAttribute("type", "hidden").addAttribute("name", varName).addAttribute("value", varValue));
        ret.addHElements(Tag.input.newInstance().addAttribute("type", "submit").addAttribute("value", buttonLabel));
        return ret;
    }

    public static boolean setAttrOfNthSubelement(@MayNull HElement el, int n, String attr, String value) {
        if (el == null) {
            return false;
        }
        if (el.getDirectSubelements().size() > n) {
            HElement e = el.getDirectSubelements().get(n);
            if (e != null) {
                e.addAttribute(attr, value);
            }
            return true;
        }
        return false;
    }

    @MayNull
    public static HElement getNthElement(HElement el, int n) {
        if (el == null) {
            return null;
        }
        if (el.getDirectSubelements().size() > n) {
            return el.getDirectSubelements().get(n);
        }
        return null;
    }

    public static HElement form(String method, @MayNull String action, String ... name_type_value) {
        HElement ret = Tag.form.newInstance().addAttribute("method", method);
        if (action != null) {
            ret.addAttribute("action", action);
        }
        for (int i = 0; i < name_type_value.length; i += 3) {
            HElement add = Tag.input.newInstance().addAttribute("name", name_type_value[i]);
            if (name_type_value[i + 1] != null) {
                add.addAttribute("type", name_type_value[i + 1]);
            }
            if (name_type_value[i + 2] != null) {
                add.addAttribute("value", name_type_value[i + 2]);
            }
            ret.addHElements(add);
        }
        return ret;
    }

    public static HElement addAttrIfTrue(boolean condition, HElement elem, String name, String val) {
        if (condition) {
            elem.addAttribute(name, val);
        }
        return elem;
    }

    public static HElement findChildTag(HElement elem, String name) {
        for (HElement e : elem) {
            if (!e.tagName.equals(name)) continue;
            return e;
        }
        HElement ret = null;
        for (HElement e : elem) {
            ret = HElementTools.findChildTag(e, name);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public static ClonedPage basicUtf8str_head_title_body() {
        return basic.clone();
    }

    public static HElement coloredText(String color, String txt) {
        return Tag.span.newInstance().addAttribute("style", "color:" + color).setText(txt);
    }

    public static HElement thBoldRow(String ... cols) {
        HElement ret = Tag.tr.newInstance();
        for (String s : cols) {
            ret.addHElements(Tag.th.newInstance().addHElements(Tag.b.newInstance().setText(s)));
        }
        return ret;
    }

    public static HElement tdRow(String ... cols) {
        HElement ret = Tag.tr.newInstance();
        for (String s : cols) {
            ret.addHElements(Tag.td.newInstance().setText(s));
        }
        return ret;
    }

    public static HElement tdElementRow(Object ... cols) {
        HElement ret = Tag.tr.newInstance();
        for (Object o : cols) {
            if (o instanceof HElement) {
                ret.addHElements(Tag.td.newInstance().addHElements((HElement)o));
                continue;
            }
            if (o == null) continue;
            ret.addHElements(Tag.td.newInstance().setText(StringTools.toString((Object)o)));
        }
        return ret;
    }

    public static HElement errorRedTextWithBackLink(String title, String msg, String linkLabel, String link) {
        return Tag.invisibleGroup.newInstance().addHElements(Tag.h2.newInstance().setText(title), Tag.br.newInstance(), HElementTools.coloredText("red", msg), Tag.br.newInstance(), Tag.br.newInstance(), Tag.a.newInstance().addAttribute("href", link).setText(linkLabel));
    }

    public static HElement coloredTextWithBackLink(String title, String color, String msg, String linkLabel, String link) {
        return Tag.invisibleGroup.newInstance().addHElements(Tag.h2.newInstance().setText(title), Tag.br.newInstance(), HElementTools.coloredText(color, msg), Tag.br.newInstance(), Tag.br.newInstance(), Tag.a.newInstance().addAttribute("href", link).setText(linkLabel));
    }

    public static HElement scriptByURL(String url) {
        return Tag.script.newInstance().addAttribute("src", url).addAttribute("type", "text/javascript").setText("");
    }

    public static HElement scriptBySource(String source) {
        return Tag.script.newInstance().addAttribute("type", "text/javascript").setText(source);
    }

    public static HElement pageFeedBr() {
        return Tag.br.newInstance().addAttribute("stlye", "page-break-before: always");
    }

    public static HElement tagPath(HElement root, String ... path) {
        if (null == path || null == root) {
            return null;
        }
        HElement ret = root;
        for (String p : path) {
            if (null == p) {
                return null;
            }
            if (null != (ret = HElementTools.getSubElementByTagName(ret, p))) continue;
            return null;
        }
        return ret;
    }

    public static HElement parse(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        return SaxHElementParser.parseHtmlSax(is);
    }

    public static HElement getSubElementByTagName(HElement root, String name) {
        for (HElement e : root) {
            if (!name.equals(e.tagName)) continue;
            return e;
        }
        return null;
    }

    public static HElement utf8EncoindgMeta() {
        return Tag.meta.newInstance().addAttribute("http-equiv", "content-type").addAttribute("content", "text/html; charset=utf-8");
    }

    public static HElement style(String content) {
        return Tag.style.newInstance().setText(content);
    }

    public static HElement findElementById(HElement elem, String id) {
        for (HElement e : elem) {
            if (e.getAttribute("id") == null || !e.getAttribute("id").equals(id)) continue;
            return e;
        }
        HElement ret = null;
        for (HElement e : elem) {
            ret = HElementTools.findElementById(e, id);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public static String escapeHtml(String str) {
        return StringTools.multiReplaceAllString((String)str, HTML_REPLACE);
    }

    static {
        HTML_REPLACE.put((Object)"&", (Object)"&amp;");
        HTML_REPLACE.put((Object)"<", (Object)"&lt;");
        HTML_REPLACE.put((Object)">", (Object)"&gt;");
        HTML_REPLACE.put((Object)"\"", (Object)"&quot;");
        HTML_REPLACE.put((Object)"'", (Object)"&#39;");
    }
}

