/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.elements.form;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.getBy.GetByTools;
import eu.javaexperience.semantic.references.MayNotNull;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.web.HTTPRequestMethod;
import eu.javaexperience.web.elements.form.FormField;
import eu.javaexperience.web.elements.form.SimplifiedHtmlModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SimplifiedFormModel<T>
extends SimplifiedHtmlModel<T> {
    protected GetBy1<HTTPRequestMethod, T> method;
    protected GetBy1<String, T> action;
    protected GetBy1<Collection<FormField<T>>, T> fields;

    @SafeVarargs
    public static <T> SimplifiedFormModel<T> createSimple(@MayNotNull HTTPRequestMethod method, @MayNull String action, @MayNull String id, @MayNull String classes, @MayNull Collection<Map.Entry<String, String>> dataset, FormField<T> ... fields) {
        SimplifiedFormModel<T> ret = new SimplifiedFormModel<T>();
        if (null == method) {
            method = HTTPRequestMethod.POST;
        }
        ret.setMethodFixed(method);
        ret.setActionFixed(action);
        ret.setIdFixed(id);
        ret.setClassesFixed(classes);
        ret.setDatasetFixed(dataset);
        List<FormField<T>> f = Arrays.asList(fields);
        ret.setFieldsFixed(f);
        return ret;
    }

    public GetBy1<HTTPRequestMethod, T> getMethod() {
        return this.method;
    }

    public HTTPRequestMethod getMethod(T ctx) {
        return (HTTPRequestMethod)this.method.getBy(ctx);
    }

    public void setMethod(GetBy1<HTTPRequestMethod, T> method) {
        this.method = method;
    }

    public void setMethodFixed(HTTPRequestMethod method) {
        AssertArgument.assertNotNull((Object)method, (String)"method");
        this.method = GetByTools.alwaysReturnWith((Object)method);
    }

    public GetBy1<String, T> getAction() {
        return this.action;
    }

    public String getAction(T ctx) {
        return (String)GetByTools.tryGet(this.action, ctx);
    }

    public void setAction(GetBy1<String, T> action) {
        this.action = action;
    }

    public void setActionFixed(String action) {
        this.action = null == action ? null : GetByTools.alwaysReturnWith((Object)action);
    }

    public GetBy1<Collection<FormField<T>>, T> getFields() {
        return this.fields;
    }

    public Collection<FormField<T>> getFields(T ctx) {
        return (Collection)GetByTools.tryGet(this.fields, ctx);
    }

    public void setFields(GetBy1<Collection<FormField<T>>, T> fields) {
        this.fields = fields;
    }

    public void setFieldsFixed(Collection<FormField<T>> fields) {
        this.fields = null == fields ? null : GetByTools.alwaysReturnWith(fields);
    }
}

