/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.fw;

import eu.javaexperience.web.facility.SiteFacility;
import eu.javaexperience.web.fw.AbstractGroup;
import eu.javaexperience.web.fw.AbstractUser;

public class ManagedUser
implements AbstractUser {
    protected final SiteFacility owner;
    protected final String username;

    public ManagedUser(SiteFacility owner, String username) {
        this.owner = owner;
        this.username = username;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public AbstractGroup[] getGroups() {
        return this.owner.getUserAndGroupManager().getGroupsOfUser(this);
    }

    @Override
    public SiteFacility getOwnerSiteObject() {
        return this.owner;
    }

    @Override
    public void setPassword(String passwd) {
        this.owner.getUserAndGroupManager().setPassword(this, passwd);
    }

    @Override
    public boolean isPassword(String passwd) {
        return this.owner.getUserAndGroupManager().isPassword(this, passwd);
    }

    @Override
    public void addGroup(AbstractGroup grp) {
        this.owner.getUserAndGroupManager().addUserToGroup(this, grp);
    }

    @Override
    public void removeGroup(AbstractGroup grp) {
        this.owner.getUserAndGroupManager().removeUserFromGroup(this, grp);
    }

    @Override
    public Object getExtraInfo(String key) throws Exception {
        return this.owner.getUserAndGroupManager().getUserExtraInfo(this, key);
    }

    @Override
    public void setExtraInfo(String key, Object o) throws Exception {
        this.owner.getUserAndGroupManager().setUserExtraInfo(this, key, o);
    }
}

