/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.fw;

import eu.javaexperience.web.Context;
import eu.javaexperience.web.HttpTools;
import eu.javaexperience.web.elements.ClonePageFactory;
import eu.javaexperience.web.elements.ClonedPage;
import eu.javaexperience.web.elements.HElement;
import eu.javaexperience.web.elements.HtmlPart;
import eu.javaexperience.web.elements.Tag;
import eu.javaexperience.web.facility.SiteFacilityTools;
import eu.javaexperience.web.fw.permission.SiteOwnableObject;
import eu.javaexperience.web.fw.template.dom.HElementTemplate;
import eu.javaexperience.web.template.Template;
import java.io.IOException;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptException;

public class SiteObjectTools {
    public static String identityhttpRedirectMetaSzekcio = "url";
    public static final ClonePageFactory httpRedirect = new ClonePageFactory(Tag.doctypeHtml.newInstance().addHElements(Tag.head.newInstance().addHElements(new HtmlPart(identityhttpRedirectMetaSzekcio).addHElements(Tag.meta.newInstance().addAttribute("http-equiv", "refresh")))));
    public static final Template hianyzoView = new HElementTemplate(new ClonePageFactory(Tag.span.newInstance().setText("Hi\u00e1nyz\u00f3 view.")));
    public static int AbstractUser_READ = 128;
    public static int AbstractUser_WRITE = 64;
    public static int GROUP_READ = 32;
    public static int GROUP_WRITE = 16;
    public static int OTHER_READ = 8;
    public static int OTHER_WRITE = 4;
    public static final long startTime = HttpTools.getWebDate((long)System.currentTimeMillis());

    public static int parseIntOrReportError(Context ctx, String val, String reportField, String reportText) throws Exception {
        try {
            return Integer.parseInt(val);
        }
        catch (Exception e) {
            SiteFacilityTools.finishWithLastViewSet((Context)ctx, (String)reportField, (Object)reportText);
            return -1;
        }
    }

    public static long parseLongOrReportError(Context ctx, String val, String reportField, String reportText) throws Exception {
        try {
            return Long.parseLong(val);
        }
        catch (Exception e) {
            SiteFacilityTools.finishWithLastViewSet((Context)ctx, (String)reportField, (Object)reportText);
            return -1L;
        }
    }

    public static void htmlRedirect(Context ctx, String path) {
        ClonedPage root = httpRedirect.clone();
        root.getByJel(identityhttpRedirectMetaSzekcio).addAttribute("content", "0;url=" + path);
        try {
            root.getRoot().append(ctx.getResponse().getWriter());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ctx.finishOperation();
    }

    public static Object evalCompiledScript(CompiledScript js, Object disz) throws ScriptException {
        Context ctx = SiteFacilityTools.getCurrentContext();
        Bindings b = js.getEngine().createBindings();
        b.put("this", disz);
        b.put("disz", disz);
        b.put("ctx", (Object)ctx);
        return js.eval(b);
    }

    public static void finishWithElementSend(Context ctx, HElement ele) {
        SiteFacilityTools.tryCallBeforeHeaderSent((Context)ctx);
        try {
            ele.append(ctx.getResponse().getWriter());
            ctx.getResponse().getWriter().flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ctx.finishOperation();
    }

    private static void setPerm(SiteOwnableObject obj, boolean r, int perm) {
        int permission = obj.getPermission();
        permission = r ? (permission |= perm) : (permission &= ~perm);
        obj.setPermission(permission);
    }

    public static void setUserRead(SiteOwnableObject obj, boolean r) {
        SiteObjectTools.setPerm(obj, r, AbstractUser_READ);
    }

    public static void setUserWrite(SiteOwnableObject obj, boolean r) {
        SiteObjectTools.setPerm(obj, r, AbstractUser_WRITE);
    }

    public static void setGroupRead(SiteOwnableObject obj, boolean r) {
        SiteObjectTools.setPerm(obj, r, GROUP_READ);
    }

    public static void setGroupWrite(SiteOwnableObject obj, boolean r) {
        SiteObjectTools.setPerm(obj, r, GROUP_WRITE);
    }

    public static void setOtherRead(SiteOwnableObject obj, boolean r) {
        SiteObjectTools.setPerm(obj, r, OTHER_READ);
    }

    public static void setOtherWrite(SiteOwnableObject obj, boolean r) {
        SiteObjectTools.setPerm(obj, r, OTHER_WRITE);
    }

    private static boolean hasPermission(SiteOwnableObject obj, int perm) {
        return (obj.getPermission() & perm) == perm;
    }

    public static boolean hasUserReadPermission(SiteOwnableObject obj) {
        return SiteObjectTools.hasPermission(obj, AbstractUser_READ);
    }

    public static boolean hasUserWritePermission(SiteOwnableObject obj) {
        return SiteObjectTools.hasPermission(obj, AbstractUser_WRITE);
    }

    public static boolean hasGroupReadPermission(SiteOwnableObject obj) {
        return SiteObjectTools.hasPermission(obj, GROUP_READ);
    }

    public static boolean hasGroupWritePermission(SiteOwnableObject obj) {
        return SiteObjectTools.hasPermission(obj, GROUP_WRITE);
    }

    public static boolean hasOtherReadPermission(SiteOwnableObject obj) {
        return SiteObjectTools.hasPermission(obj, OTHER_READ);
    }

    public static boolean hasOtherWritePermission(SiteOwnableObject obj) {
        return SiteObjectTools.hasPermission(obj, OTHER_WRITE);
    }
}

