/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.fw;

import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.text.Format;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.dispatch.url.URLNode;
import eu.javaexperience.web.facility.SiteFacility;
import eu.javaexperience.web.server.binding.HttpQueryContext;
import eu.javaexperience.web.server.binding.HttpRequest;
import eu.javaexperience.web.server.binding.HttpServingTimeMetric;
import eu.javaexperience.web.session.InMemorySessionManager;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TemplateWebsite
extends SiteFacility {
    private static final long serialVersionUID = 1L;
    protected List<URLNode> endpoints = new Vector<URLNode>();
    public static SimplePublish1<Context> beforeViewApplyLightningLogTemplateCompilationStartTime = new SimplePublish1<Context>(){

        public void publish(Context ctx) {
            HttpQueryContext lsrr = null;
            if (ctx.getRequest() instanceof HttpRequest) {
                lsrr = ((HttpRequest)ctx.getRequest()).getQuery();
                lsrr.setTimeMetric(HttpServingTimeMetric.Render, System.currentTimeMillis());
            }
        }
    };

    public TemplateWebsite(SiteFacility.SiteObjectSettings settings) {
        super(settings);
    }

    public void attachToBeginUrls(URLNode node) {
        for (URLNode n : this.endpoints) {
            n.addChild(node);
        }
    }

    public static SimplePublish1<Context> logAfterRequestEnd(final SimpleGet<? extends Appendable> appendable) {
        return new SimplePublish1<Context>(){

            public void publish(Context ctx) {
                Appendable out = (Appendable)appendable.get();
                if (null != out) {
                    StringBuilder app = new StringBuilder();
                    try {
                        HttpServletRequest req = ctx.getRequest();
                        HttpServletResponse resp = ctx.getResponse();
                        app.append(req.getRemoteAddr());
                        HttpQueryContext lsrr = null;
                        if (ctx.getRequest() instanceof HttpRequest) {
                            lsrr = ((HttpRequest)ctx.getRequest()).getQuery();
                        }
                        if (null != lsrr) {
                            long requestHandlingStartTime = lsrr.getTimeMetric(HttpServingTimeMetric.RequestStart);
                            long requestParseingEndTime = lsrr.getTimeMetric(HttpServingTimeMetric.RequestParse);
                            long requestTemplateCompileStartTime = lsrr.getTimeMetric(HttpServingTimeMetric.DispatchAndLogic);
                            app.append(" | ");
                            app.append(Format.UTC_SQL_TIMESTAMP_MS.format(new Date(requestHandlingStartTime)));
                            app.append(" | ");
                            app.append(String.valueOf(requestParseingEndTime - requestHandlingStartTime));
                            app.append(" | ");
                            long dt = requestTemplateCompileStartTime - requestParseingEndTime;
                            app.append(dt < 0L ? "-" : String.valueOf(dt));
                            app.append(" | ");
                            app.append(String.valueOf(System.currentTimeMillis() - requestHandlingStartTime));
                        } else {
                            app.append(" | ");
                            app.append(Format.sqlTimestampMilisec((Date)new Date(System.currentTimeMillis())));
                            app.append(" | ");
                        }
                        app.append(" | ");
                        app.append(req.getMethod());
                        app.append(" | ");
                        app.append(null != ctx.getProcessException() ? "E" : "Y");
                        app.append(" | ");
                        app.append(String.valueOf(resp.getStatus()));
                        app.append(" | ");
                        app.append(req.getRequestURL().toString());
                        app.append("\n");
                        out.append(app.toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
    }

    public static class TemplateWebsiteSettings
    extends SiteFacility.SiteObjectSettings {
        public URL[] rootPaths;

        public TemplateWebsiteSettings() {
            this.afterOwnerSet = null;
            this.afterRequestEnd = null;
            this.beforeHeaderSent = null;
            this.beforeRequestProcess = null;
            this.beforeViewApply = null;
            this.cookieDomain = null;
            this.cookiePath = null;
            this.createContext = null;
            this.exceptionHandler = null;
            this.onNewSession = null;
            this.onSessionDestory = null;
            this.onSessionReborn = null;
            this.rootPaths = null;
            this.sessionCookieName = null;
            this.sessionManager = new InMemorySessionManager();
            this.sessionTimeoutSecounds = 0;
            this.templateManager = null;
            this.uploadTmpDir = null;
            this.usrGrpManager = null;
        }
    }
}

