/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.fw.permission;

import eu.javaexperience.semantic.designedfor.IdentityObject;
import eu.javaexperience.semantic.designedfor.InstanceSupervisor;
import eu.javaexperience.semantic.references.ContainsNotNull;
import eu.javaexperience.semantic.references.MayNotNull;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.web.facility.SiteFacility;
import eu.javaexperience.web.facility.SiteFacilityException;
import eu.javaexperience.web.fw.AbstractGroup;
import eu.javaexperience.web.fw.AbstractUser;
import eu.javaexperience.web.fw.SiteUserAndGroupManager;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@InstanceSupervisor
public abstract class AbstractSiteUserAndGroupManager<U extends AbstractUser, G extends AbstractGroup>
implements SiteUserAndGroupManager {
    protected SiteFacility so;
    protected AbstractUser nobody;
    protected AbstractGroup nogroup;
    protected ConcurrentMap<String, U> users = new ConcurrentHashMap<String, U>();
    protected ConcurrentMap<String, G> groups = new ConcurrentHashMap<String, G>();
    public static final AbstractUser defaultNobody = new AbstractUser(){

        @Override
        public void setPassword(String passwd) {
            throw new RuntimeException("Illegal modification on nobody user");
        }

        @Override
        public void setExtraInfo(String key, Object o) throws Exception {
            throw new RuntimeException("Illegal modification on nobody user");
        }

        @Override
        public void removeGroup(AbstractGroup grp) {
            throw new RuntimeException("Illegal modification on nobody user");
        }

        @Override
        public boolean isPassword(String passwd) {
            return true;
        }

        @Override
        public String getUsername() {
            return "nobody";
        }

        @Override
        public SiteFacility getOwnerSiteObject() {
            return null;
        }

        @Override
        public AbstractGroup[] getGroups() {
            return emptyAbstractGroupArray;
        }

        @Override
        public Object getExtraInfo(String key) throws Exception {
            return null;
        }

        @Override
        public void addGroup(AbstractGroup grp) {
            throw new RuntimeException("Illegal modification on nobody user");
        }
    };
    public static final AbstractGroup defaultNogroup = new AbstractGroup(){

        @Override
        public String getGroupname() {
            return "nogroup";
        }
    };
    public static AbstractUser[] emptyAbstractUserArray = new AbstractUser[0];
    public static AbstractGroup[] emptyAbstractGroupArray = new AbstractGroup[0];

    protected abstract AbstractUser getNobody();

    protected abstract AbstractGroup getNogroup();

    protected abstract U loadUser(String var1);

    protected abstract G loadGroup(String var1);

    protected abstract U internalCreateUser(String var1, String var2);

    protected abstract void internalSetPassword(@MayNotNull U var1, @MayNotNull String var2);

    protected abstract void internalRemoveUserFromGroup(@MayNotNull U var1, @MayNotNull G var2);

    protected abstract void internalAddUserToGroup(@MayNotNull U var1, @MayNotNull G var2);

    protected abstract boolean isUserPassword(@MayNotNull U var1, @MayNotNull String var2);

    @IdentityObject
    public U getUserByUsername(String name) {
        AbstractUser re = (AbstractUser)this.users.get(name);
        if (re == null) {
            U ni = this.loadUser(name);
            if (ni == null) {
                return null;
            }
            re = (AbstractUser)this.users.putIfAbsent(name, ni);
            if (re == null) {
                re = ni;
            }
        }
        return (U)re;
    }

    @Override
    public void setPassword(AbstractUser usr, String password) {
        if (usr == null || password == null) {
            return;
        }
        this.internalSetPassword(usr, password);
    }

    @Override
    public void removeUserFromGroup(AbstractUser usr, AbstractGroup grp) {
        if (usr == null || grp == null) {
            return;
        }
        this.internalRemoveUserFromGroup(usr, grp);
    }

    public U login(String username, String password) {
        if (username == null || password == null) {
            return null;
        }
        U usr = this.getUserByUsername(username);
        if (usr == null) {
            return null;
        }
        if (this.isUserPassword(usr, password)) {
            return usr;
        }
        return null;
    }

    @Override
    public boolean isUserInGroup(AbstractUser usr, AbstractGroup grp) {
        if (usr == null || grp == null) {
            return false;
        }
        U s = this.getUserByUsername(usr.getUsername());
        if (s == null) {
            return false;
        }
        G g = this.getGroupByGroupname(grp.getGroupname());
        if (g == null) {
            return false;
        }
        String gr = grp.getGroupname();
        for (AbstractGroup str : s.getGroups()) {
            if (!gr.equals(str.getGroupname())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPassword(AbstractUser usr, String passwd) {
        if (usr == null || passwd == null) {
            return false;
        }
        return this.isUserPassword(usr, passwd);
    }

    @Override
    public AbstractUser getNobodyUser() {
        return this.nobody;
    }

    @Override
    public AbstractGroup getNobodyGroup() {
        return this.nogroup;
    }

    public G getGroupByGroupname(String name) {
        AbstractGroup re = (AbstractGroup)this.groups.get(name);
        if (re == null) {
            G ni = this.loadGroup(name);
            if (ni == null) {
                return null;
            }
            re = (AbstractGroup)this.groups.putIfAbsent(name, ni);
            if (re == null) {
                re = ni;
            }
        }
        return (G)re;
    }

    public U createUser(String username, String password) {
        if (username == null || password == null) {
            return null;
        }
        U ret = this.getUserByUsername(username);
        if (ret != null) {
            return null;
        }
        U u = this.internalCreateUser(username, password);
        if (this.users.putIfAbsent(username, u) != null) {
            return null;
        }
        return ret;
    }

    @Override
    public void addUserToGroup(AbstractUser usr, AbstractGroup grp) {
        if (usr == null || grp == null) {
            return;
        }
        if (usr.getUsername() == null || grp.getGroupname() == null) {
            return;
        }
        U user = this.getUserByUsername(usr.getUsername());
        G group = this.getGroupByGroupname(grp.getGroupname());
        this.internalAddUserToGroup(user, group);
    }

    @Override
    public void init(SiteFacility so) {
        this.so = so;
        this.nobody = this.getNobody();
        this.nogroup = this.getNogroup();
    }

    @MayNull
    public G createGroup(@MayNotNull String group) {
        if (group == null) {
            return null;
        }
        G ret = this.getGroupByGroupname(group);
        if (ret != null) {
            return null;
        }
        G u = this.internalCreateGroup(group);
        return u;
    }

    protected abstract G internalCreateGroup(@MayNotNull String var1);

    @Override
    @MayNotNull
    @ContainsNotNull
    public AbstractGroup[] getGroupsOfUser(@MayNotNull AbstractUser usr) throws SiteFacilityException {
        U user = this.getUserByUsername(usr.getUsername());
        if (user == null) {
            return emptyAbstractGroupArray;
        }
        AbstractGroup[] grps = user.getGroups();
        AbstractGroup[] ret = new AbstractGroup[grps.length];
        for (int i = 0; i < ret.length; ++i) {
            G g;
            ret[i] = grps[i] == null ? this.nogroup : ((g = this.getGroupByGroupname(grps[i].getGroupname())) == null ? this.nogroup : g);
        }
        return ret;
    }
}

