/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.server.commons;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.io.IOStream;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.io.file.FileTools;
import eu.javaexperience.url.UrlTools;
import eu.javaexperience.web.server.binding.HttpRequest;
import eu.javaexperience.web.server.binding.HttpRequestProperty;
import eu.javaexperience.web.server.binding.HttpSocketProtocol;
import eu.javaexperience.web.server.binding.HttpSocketProtocolHandler;
import eu.javaexperience.web.server.commons.UploadedFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;

public abstract class AbstractHttpProtocolHandler
implements HttpSocketProtocolHandler {
    protected final IOStream ioStream;
    protected final HttpSocketProtocol protocol;
    protected IOStream wrappedSocket;
    protected EnumMap<HttpRequestProperty, String> requestProperties = new EnumMap(HttpRequestProperty.class);
    protected Map<String, String> requestHeaders;
    protected Map<String, String[]> reqParams;

    public AbstractHttpProtocolHandler(IOStream stream, HttpSocketProtocol protocol) {
        this.ioStream = stream;
        this.protocol = protocol;
    }

    @Override
    public void initRequest() throws IOException {
        this.wrappedSocket = this.initSocketRequest();
    }

    protected abstract IOStream initSocketRequest() throws IOException;

    @Override
    public IOStream getWrappedStream() {
        return this.wrappedSocket;
    }

    @Override
    public IOStream getRawStream() {
        return this.ioStream;
    }

    @Override
    public HttpSocketProtocol getProtocolInfo() {
        return this.protocol;
    }

    protected void setParsedRequestProperties(String reqProtocol, String reqMethod, String reqDomain, String reqPort, String reqURI, String reqURL, String reqQuery, Map<String, String> reqHeaders, Map<String, String[]> reqQueryParams) {
        this.requestProperties.put(HttpRequestProperty.PROTOCOL, reqProtocol);
        this.requestProperties.put(HttpRequestProperty.METHOD, reqMethod);
        this.requestProperties.put(HttpRequestProperty.PORT, reqPort);
        this.requestProperties.put(HttpRequestProperty.DOMAIN, reqDomain);
        this.requestProperties.put(HttpRequestProperty.URI, reqURI);
        this.requestProperties.put(HttpRequestProperty.URL, reqURL);
        this.requestProperties.put(HttpRequestProperty.QUERY, reqQuery);
        this.requestHeaders = reqHeaders;
        this.reqParams = reqQueryParams;
    }

    @Override
    public String getHttpRequestProperty(HttpRequestProperty prop) {
        return this.requestProperties.get((Object)prop);
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    @Override
    public Map<String, String[]> getQueryParams() {
        return this.reqParams;
    }

    private String getUploadTmpDir() {
        return "/tmp/";
    }

    public static void handlePosts(HttpServletRequest request, Map<String, String[]> reqParams, String uploadDir) throws IOException {
        ServletInputStream is = request.getInputStream();
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            ServletFileUpload upload = new ServletFileUpload();
            SmallMap files = new SmallMap();
            try {
                FileItemIterator it = upload.getItemIterator(request);
                while (it.hasNext()) {
                    FileItemStream fis = it.next();
                    String name = fis.getFieldName();
                    InputStream stream = fis.openStream();
                    if (fis.isFormField()) {
                        UrlTools.putParam(reqParams, (String)name, (String)Streams.asString((InputStream)stream));
                        continue;
                    }
                    File file = FileTools.generateTempFilename((String)uploadDir, (int)30, (String)".tmp");
                    FileOutputStream fos = new FileOutputStream(file);
                    IOTools.copyStream((InputStream)stream, (OutputStream)fos);
                    fos.flush();
                    fos.close();
                    UploadedFile fi = new UploadedFile(file, fis.getName());
                    files.put(name, fi);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            request.setAttribute("files", (Object)files);
            return;
        }
        int n = request.getContentLength();
        int ava = is.available();
        if (n <= 0 && ava > 0) {
            n = is.available();
        }
        byte[] data = null;
        if (n > 0) {
            data = new byte[n];
            IOTools.readFull((InputStream)is, (byte[])data);
        } else {
            data = IOTools.loadAllAvailableFromInputStream((InputStream)is);
        }
        try {
            UrlTools.processArgsRequest((String)new String(data), reqParams);
        }
        catch (Exception exception) {
            // empty catch block
        }
        request.setAttribute("data", (Object)data);
    }

    @Override
    public void handlePosts(HttpRequest request) throws IOException {
        AbstractHttpProtocolHandler.handlePosts(request, this.reqParams, this.getUploadTmpDir());
    }

    public static void appendHttpStatus(Appendable sb, int status, String msg, String lineEnd) throws IOException {
        sb.append("HTTP/1.1 ");
        sb.append(String.valueOf(status));
        sb.append(" ");
        sb.append(msg);
        sb.append(lineEnd);
    }

    public static void appendHeaders(Appendable sb, Map<String, String> send, String lineEnd) throws IOException {
        for (Map.Entry<String, String> kv : send.entrySet()) {
            sb.append(kv.getKey());
            sb.append(": ");
            sb.append(kv.getValue());
            sb.append(lineEnd);
        }
    }
}

