/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.server.commons;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.collection.map.KeyVal;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.io.IOStream;
import eu.javaexperience.io.IOStreamServer;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.io.IpAddressTools;
import eu.javaexperience.io.fd.IOStreamFactory;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.resource.pool.ResourcePool;
import eu.javaexperience.resource.pool.SimplifiedResourcePool;
import eu.javaexperience.server.AbstractServer;
import eu.javaexperience.web.server.binding.HttpSocketProtocol;
import eu.javaexperience.web.server.binding.WellKnownSocketHttpProtocol;
import eu.javaexperience.web.server.commons.LightningConnectionClosed;
import eu.javaexperience.web.server.commons.LightningTools;
import eu.javaexperience.web.server.example.ExampleServlet;
import eu.javaexperience.web.server.lightningImpl.LightningHttpQueryContext;
import java.io.Closeable;
import java.io.Flushable;
import java.net.ServerSocket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;

public class Lightning<T extends IOStream>
extends AbstractServer<T> {
    protected final HttpServlet servlet;
    protected final HttpSocketProtocol protocol;
    protected static final ResourcePool<byte[]> BUFFER_POOL = new SimplifiedResourcePool((SimpleGet)new SimpleGet<byte[]>(){

        public byte[] get() {
            return new byte[307200];
        }
    });
    protected ConcurrentMap<Integer, Map.Entry<AtomicInteger, ConcurrentLinkedQueue<T>>> connectionPerIp = new ConcurrentHashMap<Integer, Map.Entry<AtomicInteger, ConcurrentLinkedQueue<T>>>();
    protected boolean enableKeepAlive = true;
    protected int maxConnectionPerIp = -1;
    protected final SimplePublish1<LightningHttpQueryContext> requestHandler = new SimplePublish1<LightningHttpQueryContext>(){

        public void publish(LightningHttpQueryContext ssrr) {
            try {
                Lightning.this.servlet.service((ServletRequest)ssrr.request, (ServletResponse)ssrr.response);
            }
            catch (Exception e) {
                Mirror.propagateAnyway((Throwable)e);
            }
        }
    };

    public Lightning(IOStreamServer<T> srv, int initialWorkerCount, HttpServlet servlet) {
        this(srv, WellKnownSocketHttpProtocol.RAW_HTTP, initialWorkerCount, servlet);
    }

    public Lightning(IOStreamServer<T> srv, HttpSocketProtocol protocol, int initialWorkerCount, HttpServlet servlet) {
        super(srv, initialWorkerCount);
        this.protocol = protocol;
        AssertArgument.assertNotNull((Object)this.protocol, (String)"protocol");
        this.servlet = servlet;
        AssertArgument.assertNotNull((Object)this.servlet, (String)"servlet");
    }

    protected static <T extends IOStream> boolean tryPushConnection(ConcurrentMap<Integer, Map.Entry<AtomicInteger, ConcurrentLinkedQueue<T>>> connPerIp, T socket, int ip, int maxConnectionPerIp) {
        Map.Entry kv = (Map.Entry)connPerIp.get(ip);
        if (null == kv) {
            KeyVal q = new KeyVal((Object)new AtomicInteger(), new ConcurrentLinkedQueue());
            kv = (Map.Entry)connPerIp.putIfAbsent(ip, (Map.Entry<AtomicInteger, ConcurrentLinkedQueue<T>>)q);
            if (null == kv) {
                kv = q;
            }
        }
        if (Lightning.isTooManyConnectionOfHost(connPerIp, ip, maxConnectionPerIp)) {
            ((ConcurrentLinkedQueue)kv.getValue()).add(socket);
            return true;
        }
        return false;
    }

    protected static <T extends IOStream> boolean isTooManyConnectionOfHost(ConcurrentMap<Integer, Map.Entry<AtomicInteger, ConcurrentLinkedQueue<T>>> connPerIp, int ip, int maxConnectionPerIp) {
        return Lightning.isTooManyConnectionOfHost((Map.Entry)connPerIp.get(ip), maxConnectionPerIp);
    }

    protected static <T extends IOStream> boolean isTooManyConnectionOfHost(Map.Entry<AtomicInteger, ConcurrentLinkedQueue<T>> kv, int maxConnectionPerIp) {
        if (null == kv) {
            return false;
        }
        return kv.getKey().incrementAndGet() > maxConnectionPerIp;
    }

    protected static <T> T tryPopConnection(ConcurrentMap<Integer, Map.Entry<AtomicInteger, ConcurrentLinkedQueue<T>>> connPerIp, int ip) {
        Map.Entry kv = (Map.Entry)connPerIp.get(ip);
        if (null != kv) {
            ((AtomicInteger)kv.getKey()).decrementAndGet();
            return (T)((ConcurrentLinkedQueue)kv.getValue()).poll();
        }
        return null;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.enableKeepAlive = keepAlive;
    }

    public void setMaxConnectionPerIp(int conn) {
        if (conn < 0) {
            conn = 0;
        }
        this.maxConnectionPerIp = conn;
    }

    public static void main(String[] args) throws Throwable {
        IOStreamServer srv = IOStreamFactory.fromServerSocket((ServerSocket)new ServerSocket(8888));
        int initialWorkerCount = 5;
        ExampleServlet servlet = new ExampleServlet();
        Lightning l = new Lightning(srv, initialWorkerCount, servlet);
        l.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(T subject) {
        byte[] buffer;
        int ip = 0;
        if (this.maxConnectionPerIp > 0 && Lightning.tryPushConnection(this.connectionPerIp, subject, ip = IpAddressTools.parseIPv4AsInt((String)subject.remoteAddress()), this.maxConnectionPerIp)) {
            System.out.println("pushed:" + IpAddressTools.getIpAddress((int)ip));
            return;
        }
        try {
            buffer = (byte[])BUFFER_POOL.acquireResource();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
            return;
        }
        while (true) {
            LightningHttpQueryContext ssrr = null;
            try {
                do {
                    ssrr = LightningTools.handleRequest(this.protocol, subject, this.requestHandler);
                    ssrr.destroy();
                } while (this.enableKeepAlive && !"close".equalsIgnoreCase(ssrr.request.getHeader("Connection")) && ssrr.isLengthGivenAtHeaderSend() && !Lightning.isTooManyConnectionOfHost(this.connectionPerIp, ip, this.maxConnectionPerIp));
            }
            catch (LightningConnectionClosed lightningConnectionClosed) {
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                if (null != ssrr) {
                    IOTools.silentFlush((Flushable)ssrr);
                    IOTools.silentClose((Closeable)ssrr);
                }
                IOTools.silentFlush(subject);
                IOTools.silentClose(subject);
            }
            if (null == (subject = (IOStream)Lightning.tryPopConnection(this.connectionPerIp, ip))) break;
            ip = IpAddressTools.parseIPv4AsInt((String)subject.remoteAddress());
            System.out.println("pop:" + IpAddressTools.getIpAddress((int)ip));
        }
        if (null != buffer) {
            BUFFER_POOL.releaseResource((Object)buffer);
        }
    }
}

