/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.server.lightning.protocol;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.io.IOStream;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.io.fd.IOStreamFactory;
import eu.javaexperience.regex.RegexTools;
import eu.javaexperience.url.UrlTools;
import eu.javaexperience.web.server.binding.WellKnownSocketHttpProtocol;
import eu.javaexperience.web.server.commons.AbstractHttpProtocolHandler;
import eu.javaexperience.web.server.commons.LightningConnectionClosed;
import eu.javaexperience.web.server.commons.LightningOutput;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class PlainHttpProtocolHandler
extends AbstractHttpProtocolHandler {
    protected static final byte[] LINE_TERMINATE_SEQUENCE = new byte[]{13, 10};
    protected static final byte[] REQUEST_TERMINATE_SEQUENCE = new byte[]{13, 10, 13, 10};

    public PlainHttpProtocolHandler(IOStream stream) {
        super(stream, WellKnownSocketHttpProtocol.RAW_HTTP);
    }

    protected static void parseHeaders(Collection<String> dst, byte[] data, int len) {
        int prev = 0;
        int index = -1;
        do {
            if (-1 == (index = IOTools.indexOfBytes((byte[])data, (byte[])LINE_TERMINATE_SEQUENCE, (int)prev, (int)len))) continue;
            dst.add(new String(data, prev, index - prev));
            prev = index + 2;
        } while (-1 != index);
    }

    protected void processHeaders(List<String> headers) throws IOException {
        String urlQuery = "";
        SmallMap reqHeaders = new SmallMap();
        SmallMap queryParams = new SmallMap();
        String reqURI = null;
        String reqDomain = null;
        String reqProtocol = null;
        String reqMethod = null;
        String reqPort = "0";
        String[] fl = RegexTools.SPACES.split(headers.get(0));
        reqMethod = fl[0];
        reqURI = fl[1];
        reqProtocol = fl[2];
        String head = null;
        for (int i = 1; i < headers.size(); ++i) {
            String[] splitted;
            String line = headers.get(i);
            if (0 == line.length() || (splitted = RegexTools.HEADER_LINES.split(line, 2)).length != 2) continue;
            if ("host".equalsIgnoreCase(splitted[0])) {
                head = splitted[1];
            }
            reqHeaders.put((Object)splitted[0], (Object)splitted[1]);
        }
        if (null == head) {
            throw new IOException("No host specified in the request header!");
        }
        String[] hds = head.split(":");
        reqPort = hds.length == 1 ? "80" : hds[1];
        reqDomain = hds[0];
        String[] urlsp = RegexTools.QUESTION_MARK.split(reqURI, 2);
        String reqURL = urlsp[0];
        if (urlsp.length > 1) {
            urlQuery = urlsp[1];
            UrlTools.processArgsRequest((String)urlsp[1], (Map)queryParams);
        }
        this.setParsedRequestProperties(reqProtocol, reqMethod, reqDomain, reqPort, reqURI, reqURL, urlQuery, (Map<String, String>)reqHeaders, (Map<String, String[]>)queryParams);
    }

    protected int readRequestHeaders(BufferedInputStream is, byte[] data) throws IOException {
        is.mark(data.length);
        int readSize = is.read(data);
        int index = IOTools.indexOfBytes((byte[])data, (byte[])REQUEST_TERMINATE_SEQUENCE, (int)0, (int)readSize);
        while (readSize >= 0 && -1 == index && readSize != data.length) {
            int read = is.read(data, readSize, data.length - readSize);
            if (read < 0) {
                readSize = -1;
                break;
            }
            index = IOTools.indexOfBytes((byte[])data, (byte[])REQUEST_TERMINATE_SEQUENCE, (int)Math.max(0, (readSize += read) - 4), (int)(data.length - readSize));
        }
        if (readSize <= 0) {
            throw new LightningConnectionClosed("Connection closed");
        }
        if (-1 == index) {
            throw new IOException("Request header size exceed " + data.length + " byte size limit");
        }
        is.reset();
        is.skip(index + 4);
        return index + 4;
    }

    protected InputStream handleInputRequest() throws IOException {
        int limit = 3072;
        BufferedInputStream is = new BufferedInputStream(this.getRawStream().getInputStream());
        ArrayList<String> headers = new ArrayList<String>(5);
        byte[] data = new byte[limit];
        int readSize = this.readRequestHeaders(is, data);
        PlainHttpProtocolHandler.parseHeaders(headers, data, readSize);
        this.processHeaders(headers);
        return is;
    }

    protected InputStream old_handleInputRequest() throws IOException {
        String urlQuery = "";
        SmallMap reqHeaders = new SmallMap();
        SmallMap queryParams = new SmallMap();
        String reqURI = null;
        String reqDomain = null;
        String reqProtocol = null;
        String reqMethod = null;
        String reqPort = "0";
        InputStream is = this.getRawStream().getInputStream();
        ArrayList<String> hed = new ArrayList<String>(5);
        String crnrlr = null;
        int limit = 10240;
        byte[] readBuffer = new byte[limit];
        int hr = 0;
        while (!"".equals(crnrlr = IOTools.readLine_rn((InputStream)is, (byte[])readBuffer, (int)readBuffer.length))) {
            if (hr > limit) {
                throw new IOException("Request header size exceed " + limit + " byte size limit");
            }
            if (crnrlr == null) {
                throw new LightningConnectionClosed("Connection closed");
            }
            hed.add(crnrlr);
            hr += crnrlr.length();
        }
        String[] fl = RegexTools.SPACES.split((CharSequence)hed.get(0));
        reqMethod = fl[0];
        reqURI = fl[1];
        reqProtocol = fl[2];
        String head = null;
        for (int i = 1; i < hed.size(); ++i) {
            String[] splitted = RegexTools.HEADER_LINES.split((CharSequence)hed.get(i), 2);
            if (splitted.length != 2) continue;
            if ("host".equalsIgnoreCase(splitted[0])) {
                head = splitted[1];
            }
            reqHeaders.put((Object)splitted[0], (Object)splitted[1]);
        }
        if (null == head) {
            throw new IOException("No host specified in the request header!");
        }
        String[] hds = head.split(":");
        reqPort = hds.length == 1 ? "80" : hds[1];
        reqDomain = hds[0];
        String[] urlsp = RegexTools.QUESTION_MARK.split(reqURI, 2);
        String reqURL = urlsp[0];
        if (urlsp.length > 1) {
            urlQuery = urlsp[1];
            UrlTools.processArgsRequest((String)urlsp[1], (Map)queryParams);
        }
        this.setParsedRequestProperties(reqProtocol, reqMethod, reqDomain, reqPort, reqURI, reqURL, urlQuery, (Map<String, String>)reqHeaders, (Map<String, String[]>)queryParams);
        return is;
    }

    @Override
    protected IOStream initSocketRequest() throws IOException {
        InputStream is = this.old_handleInputRequest();
        return IOStreamFactory.fromInAndOutputStream((InputStream)is, (OutputStream)this.getRawStream().getOutputStream());
    }

    @Override
    public void sendResponseHeaders(LightningOutput os, int status, String responseHead, Map<String, String> send) throws IOException {
        StringBuilder sb = new StringBuilder();
        PlainHttpProtocolHandler.appendHttpStatus(sb, status, responseHead, "\r\n");
        PlainHttpProtocolHandler.appendHeaders(sb, send, "\r\n");
        sb.append("\r\n");
        os.getBackendOutput().write(sb.toString().getBytes());
    }

    @Override
    public void finishTransmission(LightningOutput os) throws IOException {
    }
}

