/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.server.lightningImpl;

import eu.javaexperience.collection.enumerations.EnumerationFromIterator;
import eu.javaexperience.collection.enumerations.OneShotEnumeration;
import eu.javaexperience.collection.map.BulkTransitMap;
import eu.javaexperience.collection.map.MapTools;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.io.AutoFlushListener;
import eu.javaexperience.io.IOStream;
import eu.javaexperience.parse.ParsePrimitive;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.web.Headers;
import eu.javaexperience.web.HttpResponseStatusCode;
import eu.javaexperience.web.HttpTools;
import eu.javaexperience.web.MIME;
import eu.javaexperience.web.features.WebSocketEndpoint;
import eu.javaexperience.web.server.binding.HttpQueryContext;
import eu.javaexperience.web.server.binding.HttpRequest;
import eu.javaexperience.web.server.binding.HttpRequestProperty;
import eu.javaexperience.web.server.binding.HttpResponse;
import eu.javaexperience.web.server.binding.HttpServingTimeMetric;
import eu.javaexperience.web.server.binding.HttpSocketProtocolHandler;
import eu.javaexperience.web.server.commons.LightningConnectionClosed;
import eu.javaexperience.web.server.commons.LightningOutput;
import eu.javaexperience.web.server.commons.UploadedFile;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.ReadListener;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;

public class LightningHttpQueryContext
implements Closeable,
AutoCloseable,
Flushable,
HttpQueryContext {
    protected final IOStream socket;
    protected final Map<String, String> respHeader = LightningHttpQueryContext.defaultResponseHeaders();
    protected final List<Cookie> outCookies = new ArrayList<Cookie>();
    protected final List<Cookie> inCookies = new ArrayList<Cookie>();
    protected HttpResponseStatusCode statusResponse = HttpResponseStatusCode._200_OK;
    protected boolean isServiceEnded = false;
    protected int bufferSize;
    protected final HttpSocketProtocolHandler protocolHandler;
    protected final LightningOutput out;
    protected final InputStream is;
    private boolean headerSent = false;
    protected boolean contentLengthSet = false;
    protected boolean finalLengthSent = false;
    protected static final AutoFlushListener<LightningOutput> onAutoFlush = new AutoFlushListener<LightningOutput>(){

        public void beforeUserFlush(LightningOutput f) {
        }

        public void afterUserFlush(LightningOutput b) {
            LightningHttpQueryContext f = (LightningHttpQueryContext)b.getOwner();
            if (f.isOperationEnded()) {
                try {
                    b.flushBuffer();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public void beforeBufferFlush(LightningOutput b) {
            try {
                LightningHttpQueryContext f = (LightningHttpQueryContext)b.getOwner();
                if (!f.isHeadersSent()) {
                    f.sendHeaders();
                }
            }
            catch (Exception e) {
                Mirror.propagateAnyway((Throwable)e);
            }
        }

        public void afterBufferFlush(LightningOutput f) {
        }
    };
    protected ServletOutputStream sos = null;
    protected ServletInputStream sin = null;
    protected HttpSession session;
    private Map<String, Object> attr = null;
    private int contentLength = -1;
    public final HttpRequest request = new HttpRequest(){

        public Object getAttribute(String name) {
            if ("lightning".equals(name)) {
                return LightningHttpQueryContext.this;
            }
            if (LightningHttpQueryContext.this.attr == null) {
                return null;
            }
            return LightningHttpQueryContext.this.attr.get(name);
        }

        public Enumeration<String> getAttributeNames() {
            if (LightningHttpQueryContext.this.attr == null) {
                return new OneShotEnumeration((Object)"lightning");
            }
            return new EnumerationFromIterator(LightningHttpQueryContext.this.attr.keySet());
        }

        public String getCharacterEncoding() {
            return this.getHeader("accept-charset");
        }

        public int getContentLength() {
            String hcl = this.getHeader("http_content_length");
            String cl = this.getHeader("Content-Length");
            if (hcl != null) {
                return Integer.parseInt(hcl);
            }
            if (cl != null) {
                return Integer.parseInt(cl);
            }
            return -1;
        }

        public String getContentType() {
            return this.getHeader("Content-Type");
        }

        public String getParameter(String name) {
            String[] re = LightningHttpQueryContext.this.protocolHandler.getQueryParams().get(name);
            if (re == null || re.length == 0) {
                return null;
            }
            return re[0];
        }

        public Enumeration<String> getParameterNames() {
            return new EnumerationFromIterator(LightningHttpQueryContext.this.protocolHandler.getQueryParams().keySet());
        }

        public String[] getParameterValues(String name) {
            return LightningHttpQueryContext.this.protocolHandler.getQueryParams().keySet().toArray(Mirror.emptyStringArray);
        }

        public Map<String, String[]> getParameterMap() {
            return LightningHttpQueryContext.this.protocolHandler.getQueryParams();
        }

        public void setAttribute(String name, Object o) {
            if (LightningHttpQueryContext.this.attr == null) {
                LightningHttpQueryContext.this.attr = (Map)new SmallMap();
            }
            LightningHttpQueryContext.this.attr.put(name, o);
        }

        public void removeAttribute(String name) {
            if (LightningHttpQueryContext.this.attr != null) {
                LightningHttpQueryContext.this.attr.remove(name);
            }
        }

        public ServletInputStream getInputStream() throws IOException {
            if (LightningHttpQueryContext.this.sin == null) {
                LightningHttpQueryContext.this.sin = LightningHttpQueryContext.this.initSin();
            }
            return LightningHttpQueryContext.this.sin;
        }

        public String getRequestProtocol() {
            return LightningHttpQueryContext.this.protocolHandler.getHttpRequestProperty(HttpRequestProperty.PROTOCOL);
        }

        public int getRequestPort() {
            return Integer.parseInt(LightningHttpQueryContext.this.protocolHandler.getHttpRequestProperty(HttpRequestProperty.PORT));
        }

        public String getRequestDomain() {
            return LightningHttpQueryContext.this.protocolHandler.getHttpRequestProperty(HttpRequestProperty.DOMAIN);
        }

        public String getRequestPath() {
            return LightningHttpQueryContext.this.protocolHandler.getHttpRequestProperty(HttpRequestProperty.URI);
        }

        public StringBuffer getRequestURL() {
            Integer p;
            StringBuffer ret = new StringBuffer();
            ret.append("http://");
            ret.append(LightningHttpQueryContext.this.protocolHandler.getHttpRequestProperty(HttpRequestProperty.DOMAIN));
            String port = LightningHttpQueryContext.this.protocolHandler.getHttpRequestProperty(HttpRequestProperty.PORT);
            if (null != port && null != (p = ParsePrimitive.tryParseInt((String)port)) && 80 != p) {
                ret.append(":");
                ret.append(port);
            }
            ret.append(LightningHttpQueryContext.this.protocolHandler.getHttpRequestProperty(HttpRequestProperty.URI));
            return ret;
        }

        public AsyncContext startAsync(ServletRequest paramServletRequest, ServletResponse paramServletResponse) throws IllegalStateException {
            return null;
        }

        public AsyncContext startAsync() throws IllegalStateException {
            return null;
        }

        public void setCharacterEncoding(String paramString) throws UnsupportedEncodingException {
        }

        public boolean isAsyncSupported() {
            return false;
        }

        public boolean isAsyncStarted() {
            return false;
        }

        public ServletContext getServletContext() {
            return null;
        }

        public RequestDispatcher getRequestDispatcher(String paramString) {
            return null;
        }

        public String getRealPath(String paramString) {
            return null;
        }

        public Enumeration<Locale> getLocales() {
            return null;
        }

        public Locale getLocale() {
            return null;
        }

        public DispatcherType getDispatcherType() {
            return null;
        }

        public AsyncContext getAsyncContext() {
            return null;
        }

        public void logout() throws ServletException {
        }

        public void login(String paramString1, String paramString2) throws ServletException {
        }

        public boolean isUserInRole(String paramString) {
            return false;
        }

        public boolean isRequestedSessionIdValid() {
            return false;
        }

        public boolean isRequestedSessionIdFromUrl() {
            return false;
        }

        public boolean isRequestedSessionIdFromURL() {
            return false;
        }

        public boolean isRequestedSessionIdFromCookie() {
            return false;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public HttpSession getSession(boolean paramBoolean) {
            return LightningHttpQueryContext.this.session;
        }

        public HttpSession getSession() {
            return LightningHttpQueryContext.this.session;
        }

        public String getServletPath() {
            return null;
        }

        public String getRequestedSessionId() {
            return null;
        }

        public String getRequestURI() {
            return LightningHttpQueryContext.this.protocolHandler.getHttpRequestProperty(HttpRequestProperty.URL);
        }

        public String getRemoteUser() {
            return null;
        }

        public String getQueryString() {
            return LightningHttpQueryContext.this.protocolHandler.getHttpRequestProperty(HttpRequestProperty.QUERY);
        }

        public String getPathTranslated() {
            return null;
        }

        public String getPathInfo() {
            return null;
        }

        public Collection<Part> getParts() throws IOException, ServletException {
            return null;
        }

        public Part getPart(String paramString) throws IOException, ServletException {
            return null;
        }

        public String getMethod() {
            return LightningHttpQueryContext.this.protocolHandler.getHttpRequestProperty(HttpRequestProperty.METHOD);
        }

        public int getIntHeader(String paramString) {
            return 0;
        }

        public Enumeration<String> getHeaders(String paramString) {
            return null;
        }

        public Enumeration<String> getHeaderNames() {
            return new EnumerationFromIterator(LightningHttpQueryContext.this.protocolHandler.getRequestHeaders().keySet());
        }

        public String getHeader(String paramString) {
            return LightningHttpQueryContext.this.protocolHandler.getRequestHeaders().get(paramString);
        }

        public long getDateHeader(String paramString) {
            return 0L;
        }

        public Cookie[] getCookies() {
            return LightningHttpQueryContext.this.inCookies.toArray(HttpTools.emptyCookieArray);
        }

        public String getContextPath() {
            return null;
        }

        public String getAuthType() {
            return null;
        }

        public boolean authenticate(HttpServletResponse paramHttpServletResponse) throws IOException, ServletException {
            return false;
        }

        public String getProtocol() {
            return "http";
        }

        public String getScheme() {
            return null;
        }

        public String getServerName() {
            return LightningHttpQueryContext.this.protocolHandler.getHttpRequestProperty(HttpRequestProperty.DOMAIN);
        }

        public int getServerPort() {
            return Integer.parseInt(LightningHttpQueryContext.this.protocolHandler.getHttpRequestProperty(HttpRequestProperty.PORT));
        }

        public BufferedReader getReader() throws IOException {
            return null;
        }

        public String getRemoteAddr() {
            return LightningHttpQueryContext.this.socket.remoteAddress();
        }

        public String getRemoteHost() {
            return null;
        }

        public boolean isSecure() {
            return false;
        }

        public int getRemotePort() {
            return 0;
        }

        public String getLocalName() {
            return null;
        }

        public String getLocalAddr() {
            return LightningHttpQueryContext.this.socket.localAddress();
        }

        public int getLocalPort() {
            return 0;
        }

        @Override
        public HttpQueryContext getQuery() {
            return LightningHttpQueryContext.this;
        }

        public String changeSessionId() {
            return null;
        }

        public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
            return null;
        }

        public long getContentLengthLong() {
            return 0L;
        }
    };
    public final HttpResponse response = new HttpResponse(){

        public void setContentLength(int len) {
            LightningHttpQueryContext.this.respHeader.put(Headers.ContentLength.getHeaderName(), String.valueOf(len));
            LightningHttpQueryContext.this.contentLength = len;
        }

        public void setContentType(String type) {
            LightningHttpQueryContext.this.respHeader.put(Headers.ContentType.getHeaderName(), type);
        }

        public void setBufferSize(int size) {
            throw new IllegalAccessError("Buffer size is specified in ServletConfig");
        }

        public int getBufferSize() {
            return LightningHttpQueryContext.this.bufferSize;
        }

        public void flushBuffer() throws IOException {
            LightningHttpQueryContext.this.flush();
        }

        public void addCookie(Cookie cookie) {
            cookie.setComment("putCookieForBrowser");
            LightningHttpQueryContext.this.outCookies.add(cookie);
        }

        public boolean containsHeader(String name) {
            return LightningHttpQueryContext.this.respHeader.containsKey(name);
        }

        public String encodeURL(String url) {
            return URLEncoder.encode(url);
        }

        public String encodeRedirectURL(String url) {
            return URLEncoder.encode(url);
        }

        public String encodeUrl(String url) {
            return URLEncoder.encode(url);
        }

        public String encodeRedirectUrl(String url) {
            return URLEncoder.encode(url);
        }

        public void setDateHeader(String name, long date) {
            LightningHttpQueryContext.this.respHeader.put(name, HttpTools.toHeaderDate((long)date));
        }

        public void addDateHeader(String name, long date) {
            if (date < 0L) {
                return;
            }
            String app = LightningHttpQueryContext.this.respHeader.get(name);
            app = app != null ? app + "," + HttpTools.toHeaderDate((long)date) : HttpTools.toHeaderDate((long)date);
            LightningHttpQueryContext.this.respHeader.put(name, app);
        }

        public void setHeader(String name, String value) {
            LightningHttpQueryContext.this.respHeader.put(name, value);
        }

        public void addHeader(String name, String value) {
            String app = LightningHttpQueryContext.this.respHeader.get(name);
            app = app != null ? app + "," + value : value;
            LightningHttpQueryContext.this.respHeader.put(name, app);
        }

        public void setIntHeader(String name, int value) {
            LightningHttpQueryContext.this.respHeader.put(name, String.valueOf(value));
        }

        public void addIntHeader(String name, int value) {
            String app = LightningHttpQueryContext.this.respHeader.get(name);
            app = app != null ? app + "," + String.valueOf(value) : String.valueOf(value);
            LightningHttpQueryContext.this.respHeader.put(name, app);
        }

        public void setStatus(int sc) {
            LightningHttpQueryContext.this.statusResponse = HttpTools.httpResponseByNumber((int)sc);
        }

        public void setStatus(int sc, String sm) {
            LightningHttpQueryContext.this.statusResponse = HttpTools.httpResponseByNumber((int)sc);
        }

        public void setLocale(Locale paramLocale) {
        }

        public void setCharacterEncoding(String paramString) {
        }

        public void resetBuffer() {
        }

        public void reset() {
        }

        public boolean isCommitted() {
            return LightningHttpQueryContext.this.isHeadersSent();
        }

        public Locale getLocale() {
            return null;
        }

        public String getContentType() {
            return null;
        }

        public String getCharacterEncoding() {
            return null;
        }

        public void sendRedirect(String paramString) throws IOException {
            HttpTools.httpRedirect((HttpServletResponse)this, (String)paramString, (boolean)false);
        }

        public void sendError(int paramInt, String paramString) throws IOException {
            this.setStatus(paramInt, paramString);
            LightningHttpQueryContext.this.sendHeaders();
        }

        public void sendError(int paramInt) throws IOException {
            this.setStatus(paramInt);
            LightningHttpQueryContext.this.sendHeaders();
        }

        public int getStatus() {
            return LightningHttpQueryContext.this.statusResponse.getStatus();
        }

        public Collection<String> getHeaders(String paramString) {
            return null;
        }

        public Collection<String> getHeaderNames() {
            return null;
        }

        public String getHeader(String paramString) {
            return null;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return LightningHttpQueryContext.this.getServletOutputStream();
        }

        public PrintWriter getWriter() throws IOException {
            return LightningHttpQueryContext.this.out;
        }

        @Override
        public HttpQueryContext getQuery() {
            return LightningHttpQueryContext.this;
        }

        public void setContentLengthLong(long len) {
            this.setContentLength((int)len);
        }
    };
    protected final EnumMap<HttpServingTimeMetric, Long> times = new EnumMap(HttpServingTimeMetric.class);

    public void assertHeaderNotSent() {
        if (this.isHeadersSent()) {
            throw new IllegalStateException("Header alredy sent");
        }
    }

    public void fillHeaders(Map<String, String> forHeaders) {
        this.assertHeaderNotSent();
        forHeaders.putAll(this.respHeader);
        for (Cookie c : this.outCookies) {
            if (c.getComment() != "putCookieForBrowser") continue;
            forHeaders.put("Set-Cookie", HttpTools.renderCookie((Cookie)c, (boolean)false));
        }
    }

    public static Map<String, String> defaultResponseHeaders() {
        SmallMap ret = new SmallMap();
        ret.put("Content-Type", "text/html; charset=utf-8");
        ret.put("X-Powered-By", "Lightning");
        return ret;
    }

    @Override
    public IOStream getSocket() {
        return this.socket;
    }

    public LightningHttpQueryContext(HttpSocketProtocolHandler protoHandler) throws LightningConnectionClosed {
        this.protocolHandler = protoHandler;
        this.socket = protoHandler.getWrappedStream();
        for (Map.Entry<String, String> kv : protoHandler.getRequestHeaders().entrySet()) {
            HttpTools.tryRecogniseCookieHeader(this.inCookies, (String)kv.getKey(), (String)kv.getValue());
        }
        this.is = this.socket.getInputStream();
        this.out = LightningOutput.create(this.socket.getOutputStream(), onAutoFlush);
        this.out.setOwner(this);
    }

    public boolean isLengthGivenAtHeaderSend() {
        return this.finalLengthSent;
    }

    public WebSocketEndpoint upgradeWebsocket() throws IOException {
        throw new RuntimeException("TODO reimplement");
    }

    protected static void flushAnyWay(LightningHttpQueryContext lsrr) throws IOException {
        lsrr.out.flushBuffer();
    }

    public boolean isHeadersSent() {
        return this.headerSent;
    }

    public void sendHeaders() throws IOException {
        if (this.isOperationEnded()) {
            this.finalLengthSent = true;
            int len = this.getResponseContentLength();
            BulkTransitMap send = new BulkTransitMap();
            this.fillHeaders((Map<String, String>)send);
            if (len > -1) {
                send.put(Headers.ContentLength.getHeaderName(), String.valueOf(len));
            }
            this.contentLengthSet = true;
            this.sendHeaders((Map<String, String>)send);
        } else {
            BulkTransitMap send = new BulkTransitMap();
            this.fillHeaders((Map<String, String>)send);
            this.sendHeaders((Map<String, String>)send);
        }
    }

    public void sendHeaders(Map<String, String> send) throws IOException {
        if (this.headerSent) {
            throw new RuntimeException("Header already sent!");
        }
        this.headerSent = true;
        this.protocolHandler.sendResponseHeaders(this.out, this.statusResponse.getStatus(), this.statusResponse.getDescription(), send);
    }

    @Override
    public void flush() throws IOException {
        if (!this.isHeadersSent()) {
            this.sendHeaders();
        }
        this.out.flush();
        this.socket.flush();
    }

    private ServletOutputStream initSos() {
        return new ServletOutputStream(){

            public void write(int paramInt) throws IOException {
                LightningHttpQueryContext.this.out.write(paramInt);
            }

            public void write(byte[] d) throws IOException {
                LightningHttpQueryContext.this.out.write(d, 0, d.length);
            }

            public void write(byte[] d, int a, int b) throws IOException {
                LightningHttpQueryContext.this.out.write(d, a, b);
            }

            public void flush() throws IOException {
                LightningHttpQueryContext.this.out.flush();
            }

            public void close() throws IOException {
                LightningHttpQueryContext.this.out.close();
            }

            public boolean isReady() {
                return true;
            }

            public void setWriteListener(WriteListener writeListener) {
            }
        };
    }

    public ServletOutputStream getServletOutputStream() throws IOException {
        if (this.sos == null) {
            this.sos = this.initSos();
        }
        return this.sos;
    }

    @Override
    public void operationEnded() {
        this.isServiceEnded = true;
    }

    @Override
    public boolean isOperationEnded() {
        return this.isServiceEnded;
    }

    public int getResponseContentLength() {
        return this.contentLength;
    }

    public String getResponseHead() {
        return this.statusResponse.toHeaderLineWhitoutLF();
    }

    public void putExtraAttribute(String string, Object data) {
        this.request.setAttribute(string, data);
    }

    protected ServletInputStream initSin() {
        return new ServletInputStream(){

            public int read() throws IOException {
                return LightningHttpQueryContext.this.is.read();
            }

            public int read(byte[] d, int a, int b) throws IOException {
                return LightningHttpQueryContext.this.is.read(d, a, b);
            }

            public int read(byte[] d) throws IOException {
                return LightningHttpQueryContext.this.is.read(d);
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }

    @Override
    public void setSession(HttpSession session) {
        this.session = session;
    }

    public void setContentType(MIME type) {
        this.respHeader.put(Headers.ContentType.getHeaderName(), type.mime);
    }

    public void destroy() {
        Map files;
        if (this.attr != null && (files = (Map)MapTools.getIfType(this.attr, (Object)"files", Map.class)) != null) {
            for (Map.Entry kv : files.entrySet()) {
                try {
                    ((UploadedFile)kv.getValue()).getFile().delete();
                }
                catch (Throwable throwable) {}
            }
        }
        this.attr = null;
    }

    @Override
    public void close() throws IOException {
        this.destroy();
        this.socket.close();
    }

    @Override
    public HttpSocketProtocolHandler getProtocol() {
        return this.protocolHandler;
    }

    @Override
    public HttpRequest getRequest() {
        return this.request;
    }

    @Override
    public HttpResponse getResponse() {
        return this.response;
    }

    @Override
    public long getTimeMetric(HttpServingTimeMetric metic) {
        Long ret = this.times.get((Object)metic);
        if (null == ret) {
            return 0L;
        }
        return ret;
    }

    @Override
    public void setTimeMetric(HttpServingTimeMetric metic, long t) {
        this.times.put(metic, t);
    }

    @Override
    public HttpSession getSession() {
        return this.session;
    }

    public LightningOutput getLightningOutput() {
        return this.out;
    }

    protected void addProp(StringBuilder sb, String label, HttpRequestProperty prop) {
        sb.append(label);
        sb.append(": ");
        sb.append(this.protocolHandler.getHttpRequestProperty(prop));
        sb.append("\n");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(":{\n");
        this.addProp(sb, "request_url", HttpRequestProperty.URL);
        this.addProp(sb, "query", HttpRequestProperty.QUERY);
        sb.append("req_params: ");
        sb.append(MapTools.toStringMultiline(this.protocolHandler.getQueryParams()));
        return sb.toString();
    }
}

