package eu.uartbus.webapp.demo;

import static eu.jvx.js.lib.bindings.H.H;

import org.teavm.jso.browser.Window;
import org.teavm.jso.dom.html.HTMLElement;

import eu.javaexperience.electronic.uartbus.rpc.client.UartBus;
import eu.jvx.js.lib.bindings.H;
import eu.jvx.js.lib.bindings.VanillaTools;
import eu.jvx.js.lib.style.StyleTools.StyleAlaCarte;
import eu.jvx.js.lib.teavm.NativeJsSupportTeaVM;
import eu.jvx.js.lib.ui.style.StyleContainer;
import eu.uartbus.webapp.frontend.UbFrontendTools;
import eu.uartbus.webapp.modules.UbWebUtilsActivity;

public class WebDemoWebapp
{
	protected static H MAIN_FRAME;
	
	protected static final StyleContainer STYLES = new StyleContainer();
	
	static
	{
		NativeJsSupportTeaVM.init();
		VanillaTools.addToHeader((HTMLElement) STYLES.getHtml());
		STYLES.refresh();
	}
	
	public static H getDesignedRoot()
	{
		if(null == MAIN_FRAME)
		{
			VanillaTools.addToHeader(H("meta", "content", "width=device-width, initial-scale=1.0", "name", "viewport").getHtml());
		
			H(Window.current().getDocument().getBody()).
			addChilds
			(
				H("div").attrs("class", "main-site-title").style(StyleAlaCarte.TEXT_CENTER).addChilds
				(
					H("div").attrs("class", "container", "style", "background-color: white;color: black;").addChilds
					(
						H("h1").attrs("style", "margin: 0;padding: 20px;font-weight: bold;", "#text", "Uartbus demo webapp")
					)
				),
				H("div").attrs("class", "container").addChilds
				(
					H("div").attrs("class", "row").addChilds
					(
						MAIN_FRAME = H("div").attrs("id", "site_mainframe", "class", "content")
					)
				)
			);
		}
		
		return MAIN_FRAME;
	}
	
	public static void main(String[] args)
	{
		getDesignedRoot();
		UartBus bus = UbFrontendTools.getDefaultBus();
		//UbWebUtilsActivity.connectToBus(getDesignedRoot(), bus);
		UbWebUtilsActivity.bindUtilsToKey(bus, true, "U");
	}
}
