package eu.uartbus.webapp.modules;

import org.teavm.jso.browser.Window;
import org.teavm.jso.dom.events.KeyboardEvent;
import org.teavm.jso.dom.html.HTMLElement;

import eu.javaexperience.electronic.uartbus.PacketAssembler;
import eu.javaexperience.electronic.uartbus.PacketReader;
import eu.javaexperience.electronic.uartbus.UartbusConsoleEnv;
import eu.javaexperience.electronic.uartbus.UartbusConsoleEnv.UbConsoleInquiry;
import eu.javaexperience.electronic.uartbus.UartbusTools;
import eu.javaexperience.electronic.uartbus.rpc.client.UartBus;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.parse.ParsePrimitive;
import eu.jvx.js.lib.HtmlTools;
import eu.jvx.js.lib.bindings.H;
import eu.jvx.js.lib.bindings.VanillaTools;
import eu.uartbus.webapp.modules.widget.DeviceAddressesWidget;


/*

Layout:

	/--------------------------
	|
	|	Devices
	|	targetDevices
	|
	| <target device>
	|
	| Console
	|
	|--------------------
	|
	| [ping once] [ping] [blink] [grab] [reboot soft] [reboot hard]
 */
public class UbWebUtilsActivity
{
	protected H root;
	
	protected DeviceAddressesWidget addresses = new DeviceAddressesWidget();
	
	protected UbWebConsole console;
	
	protected SimplePublish1<byte[]> send;
	
	protected H targetAddr = new H("span").attrs("#text", "63");
	
	protected int targetAddress = 63;
	
	protected byte[] createPacket(byte[] data)
	{
		try
		{
			PacketAssembler pa = new PacketAssembler();
			UartbusConsoleEnv cmd = console.getConsole();
			pa.writeAddressing(cmd.getAddressFrom(), cmd.getAddressTo());
			pa.write(data);
			pa.appendCrc8();
			return pa.done();
		}
		catch(Exception e)
		{}
		return null;
	}
	
	protected H repeatScale = new H("input").attrs("style", "margin:10px").attrs
	(
		"type", "range",
		"min", "0",
		"max", "7",
		"value", "3"
	);
	
	protected static int[] REPEAT_TIMES = {50, 100, 200, 500, 1000, 2000, 5000, 10000};
	
	protected H pingOnce = createActionButton("Ping once", new byte[]{1,0});
	
	protected RepeatActionButton ping = new RepeatActionButton("Ping", ()->
	{
		send.publish(createPacket(new byte[]{1,0}));
	});
	
	protected RepeatActionButton blink = new RepeatActionButton("Blink", ()->
	{
		send.publish(createPacket(new byte[]{1,2,2}));
	});
	
	//protected H grab = createActionButton("Grab", new byte[]{});
	
	protected H reboot_s = createActionButton("Reboot (soft)", new byte[]{2,0,1});
	
	protected H reboot_h = createActionButton("Reboot (hard)", new byte[]{2,0,0});
	
	protected H repeatTime = new H("span").attrs("#text", "500");
	
	public void feedPackage(byte[] data)
	{
		if(UartbusTools.isPacketCrc8Valid(data))
		{
			PacketReader pr = new PacketReader(data);
			try
			{
				addresses.addAddress(pr.readVsint());
			}
			catch(Exception e) {}
			
			try
			{
				addresses.addAddress(pr.readVsint());
			}
			catch(Exception e) {}
		}
		console.incomingPacket(data);
	}
	
	public UbWebUtilsActivity(H root, SimplePublish1<byte[]> send)
	{
		this.root = root;
		this.send = send;

		root.addChilds
		(
			addresses.getHtml(),
			new H("h3").attrs("#text", "Console")
		);
		
		this.console = new UbWebConsole(root, send);
		console.setEcho(false);
		console.getOnAddressChange().addEventListener(c->
		{
			if(UbConsoleInquiry.QUERY_ADDRESS_TO == c.getType())
			{
				setTargetAddress(c.getConsole().getAddressTo());
			}
		});
		
		addresses.getOnIdSelect().addEventListener(id->setTargetAddress(id.intValue()));
		
		root.addChilds
		(
			new H("div").addChilds
			(
				new H("span").attrs("#text", "Current target address: "),
				targetAddr
			),
			new H("div").attrs("style", "padding: 10px").addChilds
			(
				new H("span").attrs("#text", "Time delay: "),
				repeatScale,
				repeatTime
			),
			new H("div").attrs("style","padding: 10px").addChilds
			(
				pingOnce,
				ping.btn,
				blink.btn,
				//grab,
				reboot_s,
				reboot_h
			)
		);
		
		repeatScale.on("change", e->
		{
			int val = ParsePrimitive.tryParseInt(VanillaTools.getContent(repeatScale.getHtml()), 4);
			val = REPEAT_TIMES[val];
			repeatTime.attrs("#text", String.valueOf(val)+" ms");
			ping.getController().setInterval(val);
			blink.getController().setInterval(val);
		});
	}
	
	public void setTargetAddress(int target)
	{
		this.targetAddress = target;
		console.cmd.setToAddress(target);
		targetAddr.attrs("#text", String.valueOf(target));
	}
	
	public static UbWebUtilsActivity connectToBus(H container, UartBus bus)
	{
		UbWebUtilsActivity ret = new UbWebUtilsActivity(container, bus::sendRawPacket);
		bus.getUnrelatedPacketListener().addEventListener(ret::feedPackage);
		return ret;
	}
	
	public H createActionButton(String text, byte[] data)
	{
		H ret = RepeatActionButton.createButton(text);
		ret.onClick(e->send.publish(createPacket(data)));
		return ret;
	}
	
	public static void bindUtilsToKey(UartBus bus, boolean ctrl, String character)
	{
		new H((HTMLElement)VanillaTools.getDom()).on("keyup", e->
		{
			KeyboardEvent ke = (KeyboardEvent) e;
			if((!ctrl || ke.isCtrlKey()) && character.equals(ke.getKey()))
			{
				Window w = Window.current().open("", "", "width=400,height=500");
				HtmlTools.setPageTitle(w.getDocument(), "Uartbus console");
				H b = new H(w.getDocument().getBody());
				connectToBus(b, bus);
			}
		});
	}
}
