/*
 * Decompiled with CFR 0.152.
 */
package eu.uartbus.webapp.backend.connection;

import eu.javaexperience.electronic.uartbus.rpc.UartbusConnection;
import eu.javaexperience.electronic.uartbus.rpc.client.UartbusRpcClientTools;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.rpc.javaclient.JavaRpcParallelClient;
import eu.uartbus.webapp.backend.connection.UartbusConnectionDistributor;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;

public class UartbusConnectionDistributorUnit
implements Closeable {
    protected static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("UartbusConnectionDistributorUnit"));
    protected final UartbusConnectionDistributor dist;
    protected final Thread receiver;
    protected final UartbusConnection connection;

    public UartbusConnectionDistributorUnit(final UartbusConnection conn) throws IOException {
        this.connection = conn;
        this.dist = new UartbusConnectionDistributor((SimplePublish1<byte[]>)((SimplePublish1)data -> {
            try {
                conn.sendPacket(data);
            }
            catch (IOException e) {
                LoggingTools.tryLogFormatException((Logger)LOG, (LoggingDetailLevel)LogLevel.ERROR, (Throwable)e, (String)"Error while distributing packet");
            }
        }));
        this.receiver = new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        UartbusConnectionDistributorUnit.this.dist.feedPacketToDistribute(conn.getNextPacket());
                    }
                }
                catch (Exception e) {
                    LoggingTools.tryLogFormatException((Logger)LOG, (LoggingDetailLevel)LogLevel.ERROR, (Throwable)e, (String)"Error while polling packet");
                    return;
                }
            }
        };
    }

    public UartbusConnectionDistributor getDistributor() {
        return this.dist;
    }

    public static UartbusConnectionDistributorUnit connectTcp(String ip, int port) throws IOException {
        final JavaRpcParallelClient cli = UartbusRpcClientTools.openIpParallelClient((String)ip, (int)port);
        final UartbusConnection api = (UartbusConnection)cli.createApiObject(UartbusConnection.class, "uartbus");
        UartbusConnectionDistributorUnit ret = new UartbusConnectionDistributorUnit(new UartbusConnection(){

            public void close() throws IOException {
                cli.stopPacketRead();
                cli.shudown();
            }

            public void setAttribute(String key, String value) throws IOException {
                api.setAttribute(key, value);
            }

            public void sendPacket(byte[] data) throws IOException {
                api.sendPacket(data);
            }

            public Map<String, String> listAttributes() {
                return api.listAttributes();
            }

            public byte[] getNextPacket() throws IOException {
                return api.getNextPacket();
            }

            public String getAttribute(String key) throws IOException {
                return api.getAttribute(key);
            }
        });
        return ret;
    }

    public void start() {
        this.receiver.start();
    }

    @Override
    public void close() throws IOException {
        IOTools.silentClose((Closeable)this.connection);
        this.receiver.interrupt();
    }
}

