/*
 * Decompiled with CFR 0.152.
 */
package eu.uartbus.webapp.modules;

import eu.javaexperience.interfaces.simple.SimpleCall;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;

public class RepeatAction {
    protected static Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("RepeatAction"));
    protected SimpleCall action;
    protected int interval = 1000;
    protected boolean running = false;
    protected long prevAction = 0L;
    protected long nextAction = 0L;
    protected Thread runner;

    public RepeatAction(SimpleCall action) {
        this.action = action;
    }

    public void setInterval(int interval) {
        if (interval < 0) {
            interval = 0;
        }
        this.interval = interval;
        this.nextAction = this.prevAction + (long)interval;
    }

    public int getInterval() {
        return this.interval;
    }

    protected boolean needExit(Thread t) {
        return !this.running || this.runner != t;
    }

    protected Thread createRunnerThread() {
        return new Thread(){

            @Override
            public void run() {
                block4: while (!RepeatAction.this.needExit(this)) {
                    try {
                        RepeatAction.this.action.call();
                    }
                    catch (Exception e) {
                        LoggingTools.tryLogFormatException((Logger)LOG, (LoggingDetailLevel)LogLevel.ERROR, (Throwable)e, (String)"Exception occurred while executing action. `");
                    }
                    if (RepeatAction.this.needExit(this)) {
                        return;
                    }
                    RepeatAction.this.prevAction = System.currentTimeMillis();
                    RepeatAction.this.nextAction = RepeatAction.this.prevAction + (long)RepeatAction.this.interval;
                    while (true) {
                        if (System.currentTimeMillis() >= RepeatAction.this.nextAction) continue block4;
                        long sleep = Math.min(500L, RepeatAction.this.nextAction - System.currentTimeMillis());
                        try {
                            if (sleep <= 0L) continue;
                            Thread.sleep(sleep);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    break;
                }
                return;
            }
        };
    }

    public boolean start() {
        if (this.running) {
            return false;
        }
        this.prevAction = System.currentTimeMillis();
        this.nextAction = System.currentTimeMillis() + (long)this.interval;
        this.running = true;
        this.runner = this.createRunnerThread();
        this.runner.start();
        return true;
    }

    public boolean stop() {
        if (!this.running) {
            return false;
        }
        this.runner = null;
        this.running = false;
        return true;
    }

    public boolean isRunning() {
        return this.running;
    }
}

