/*
 * Decompiled with CFR 0.152.
 */
package eu.uartbus.webapp.modules;

import eu.javaexperience.electronic.uartbus.PacketAssembler;
import eu.javaexperience.electronic.uartbus.PacketReader;
import eu.javaexperience.electronic.uartbus.UartbusConsoleEnv;
import eu.javaexperience.electronic.uartbus.UartbusTools;
import eu.javaexperience.electronic.uartbus.rpc.client.UartBus;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.parse.ParsePrimitive;
import eu.jvx.js.lib.HtmlTools;
import eu.jvx.js.lib.bindings.H;
import eu.jvx.js.lib.bindings.VanillaTools;
import eu.uartbus.webapp.modules.RepeatActionButton;
import eu.uartbus.webapp.modules.UbWebConsole;
import eu.uartbus.webapp.modules.widget.DeviceAddressesWidget;
import org.teavm.jso.JSObject;
import org.teavm.jso.browser.Window;
import org.teavm.jso.dom.events.KeyboardEvent;
import org.teavm.jso.dom.html.HTMLDocument;
import org.teavm.jso.dom.html.HTMLElement;

public class UbWebUtilsActivity {
    protected H root;
    protected DeviceAddressesWidget addresses = new DeviceAddressesWidget();
    protected UbWebConsole console;
    protected SimplePublish1<byte[]> send;
    protected H targetAddr = new H("span").attrs(new String[]{"#text", "63"});
    protected int targetAddress = 63;
    protected H repeatScale = new H("input").attrs(new String[]{"style", "margin:10px"}).attrs(new String[]{"type", "range", "min", "0", "max", "7", "value", "3"});
    protected static int[] REPEAT_TIMES = new int[]{50, 100, 200, 500, 1000, 2000, 5000, 10000};
    protected H pingOnce = this.createActionButton("Ping once", new byte[]{1, 0});
    protected RepeatActionButton ping = new RepeatActionButton("Ping", () -> this.send.publish((Object)this.createPacket(new byte[]{1, 0})));
    protected RepeatActionButton blink = new RepeatActionButton("Blink", () -> this.send.publish((Object)this.createPacket(new byte[]{1, 2, 2})));
    protected H reboot_s = this.createActionButton("Reboot (soft)", new byte[]{2, 0, 1});
    protected H reboot_h = this.createActionButton("Reboot (hard)", new byte[]{2, 0, 0});
    protected H repeatTime = new H("span").attrs(new String[]{"#text", "500"});

    protected byte[] createPacket(byte[] data) {
        try {
            PacketAssembler pa = new PacketAssembler();
            UartbusConsoleEnv cmd = this.console.getConsole();
            pa.writeAddressing(cmd.getAddressFrom(), cmd.getAddressTo());
            pa.write(data);
            pa.appendCrc8();
            return pa.done();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void feedPackage(byte[] data) {
        if (UartbusTools.isPacketCrc8Valid((byte[])data)) {
            PacketReader pr = new PacketReader(data);
            try {
                this.addresses.addAddress(pr.readVsint());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.addresses.addAddress(pr.readVsint());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.console.incomingPacket(data);
    }

    public UbWebUtilsActivity(H root, SimplePublish1<byte[]> send) {
        this.root = root;
        this.send = send;
        root.addChilds(new JSObject[]{this.addresses.getHtml(), new H("h3").attrs(new String[]{"#text", "Console"})});
        this.console = new UbWebConsole(root, send);
        this.console.setEcho(false);
        this.console.getOnAddressChange().addEventListener(c -> {
            if (UartbusConsoleEnv.UbConsoleInquiry.QUERY_ADDRESS_TO == c.getType()) {
                this.setTargetAddress(c.getConsole().getAddressTo());
            }
        });
        this.addresses.getOnIdSelect().addEventListener(id -> this.setTargetAddress(id.intValue()));
        root.addChilds(new H[]{new H("div").addChilds(new H[]{new H("span").attrs(new String[]{"#text", "Current target address: "}), this.targetAddr}), new H("div").attrs(new String[]{"style", "padding: 10px"}).addChilds(new H[]{new H("span").attrs(new String[]{"#text", "Time delay: "}), this.repeatScale, this.repeatTime}), new H("div").attrs(new String[]{"style", "padding: 10px"}).addChilds(new H[]{this.pingOnce, this.ping.btn, this.blink.btn, this.reboot_s, this.reboot_h})});
        this.repeatScale.on("change", e -> {
            int val = ParsePrimitive.tryParseInt((String)VanillaTools.getContent((HTMLElement)this.repeatScale.getHtml()), (int)4);
            val = REPEAT_TIMES[val];
            this.repeatTime.attrs(new String[]{"#text", String.valueOf(val) + " ms"});
            this.ping.getController().setInterval(val);
            this.blink.getController().setInterval(val);
        });
    }

    public void setTargetAddress(int target) {
        this.targetAddress = target;
        this.console.cmd.setToAddress(target);
        this.targetAddr.attrs(new String[]{"#text", String.valueOf(target)});
    }

    public static UbWebUtilsActivity connectToBus(H container, UartBus bus) {
        UbWebUtilsActivity ret = new UbWebUtilsActivity(container, (SimplePublish1<byte[]>)((SimplePublish1)arg_0 -> ((UartBus)bus).sendRawPacket(arg_0)));
        bus.getUnrelatedPacketListener().addEventListener(ret::feedPackage);
        return ret;
    }

    public H createActionButton(String text, byte[] data) {
        H ret = RepeatActionButton.createButton(text);
        ret.onClick(e -> this.send.publish((Object)this.createPacket(data)));
        return ret;
    }

    public static void bindUtilsToKey(UartBus bus, boolean ctrl, String character) {
        new H((HTMLElement)VanillaTools.getDom()).on("keyup", e -> {
            KeyboardEvent ke = (KeyboardEvent)e;
            if ((!ctrl || ke.isCtrlKey()) && character.equals(ke.getKey())) {
                Window w = Window.current().open("", "", "width=400,height=500");
                HtmlTools.setPageTitle((HTMLDocument)w.getDocument(), (String)"Uartbus console");
                H b = new H((HTMLElement)w.getDocument().getBody());
                UbWebUtilsActivity.connectToBus(b, bus);
            }
        });
    }
}

