package eu.uartbus.webapp;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletException;

import org.eclipse.jetty.server.Server;

import eu.javaexperience.electronic.uartbus.rpc.UartbusConnection;
import eu.javaexperience.rpc.JavaClassRpcUnboundFunctionsInstance;
import eu.javaexperience.rpc.RpcFacility;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.teasite.TeasiteBundle;
import eu.javaexperience.web.template.WebsiteTemplate;
import eu.javaexperience.web.template.WebsiteTemplate.WebsiteTemplateTemplateBuilder;
import eu.uartbus.webapp.backend.UbBackendTools;
import eu.uartbus.webapp.backend.connection.UartbusConnectionDistributorUnit;

public class UbWebServer
{
	protected String siteName;
	protected int port;
	protected Class webappClass;
	
	protected TeasiteBundle teasite;
	protected WebsiteTemplate website;
	protected Server server;
	
	public UbWebServer
	(
		String siteName,
		int port,
		@MayNull UartbusConnection ubc,
		Class appMain
	)
		throws IOException
	{
		this.siteName = siteName;
		this.port = port;
		this.webappClass = appMain;
		
		if(null != ubc)
		{
			addExtraConnection("uartbus", ubc);
		}
	}
	
	protected List<RpcFacility> rpcNodes = new ArrayList<>();
	
	public void addExtraConnection(String namespace, UartbusConnection conn) throws IOException
	{
		addExtraApi(new JavaClassRpcUnboundFunctionsInstance<>(namespace, wrapPacketDistributor(conn).getDistributor(), UartbusConnection.class));
	}
	
	public void addExtraApi(RpcFacility node)
	{
		String ns = node.getRpcName();
		for(RpcFacility n:rpcNodes)
		{
			if(n.getRpcName().equals(ns))
			{
				throw new RuntimeException("Rpc namespace `"+ns+"` already present.");
			}
		}
		rpcNodes.add(node);
	}
	
	protected TeasiteBundle create()
	{
		if(UbBackendTools.isSystemInDevelMode())
		{
			new File("src/main/resources/web_resources/site/").mkdirs();
		}
		
		return new TeasiteBundle
		(
			"",
			UbBackendTools.isSystemInDevelMode(),
			UbBackendTools.resourceFile
			(
					UbBackendTools.isSystemInDevelMode()?
					"src/main/resources/web_resources"
				:
					"web_resources"
			),
			"/tmp/"+siteName,
			UbBackendTools.resourceFile((UbBackendTools.isSystemInDevelMode()?"src/main/resources/":"")+"web_resources/site/"+siteName+"_webapp.js"),
			webappClass,
			null,
			rpcNodes.toArray(new RpcFacility[0])
		);
	}
	
	//overwrite me
	protected WebsiteTemplate createWebsite()
	{
		teasite.script.getScriptNode().setCheckModifiedOnRequest(UbBackendTools.isSystemInDevelMode());
		WebsiteTemplateTemplateBuilder b = WebsiteTemplateTemplateBuilder.createDefaults();
		b.handleApp = teasite.asPathDispatch();
		b.sessionCookieName = "jvx-"+siteName+"-session";
		return new WebsiteTemplate(b);
	}
	
	public void start() throws Exception
	{
		teasite = create();
		website = createWebsite();
		server  = UbBackendTools.createServer((req,resp)->{
			try
			{
				website.service(req, resp);
			}
			catch (ServletException | IOException e)
			{
				e.printStackTrace();
			}
		}, port);
		server.start();
	}
	
	public static UartbusConnectionDistributorUnit wrapPacketDistributor(UartbusConnection conn) throws IOException
	{
		UartbusConnectionDistributorUnit ret = new UartbusConnectionDistributorUnit(conn);
		ret.start();
		return ret;
	}
}

