/*
 * Decompiled with CFR 0.152.
 */
package eu.uartbus.webapp.backend.connection;

import eu.javaexperience.collection.map.OneShotMap;
import eu.javaexperience.electronic.uartbus.rpc.UartbusConnection;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.reflect.CastTo;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.rpc.RpcSession;
import eu.javaexperience.rpc.RpcSessionTools;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class UartbusConnectionDistributor
implements UartbusConnection {
    protected static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("UartbusConnectionDistributor"));
    protected SimplePublish1<byte[]> sendPacket;
    protected String sessionKey = "UartbusConnectionDistributor_" + System.identityHashCode(this);
    protected Set<PacketEndpointQueue> sessions = Collections.newSetFromMap(new WeakHashMap());

    public UartbusConnectionDistributor(SimplePublish1<byte[]> sendPacket) {
        this.sendPacket = sendPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void feedPacketToDistribute(byte[] packet) {
        PacketEndpointQueue[] queues = null;
        PacketEndpointQueue[] packetEndpointQueueArray = this.sessions;
        synchronized (this.sessions) {
            queues = this.sessions.toArray(PacketEndpointQueue.emptyPacketEndpointQueue);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (PacketEndpointQueue sess : queues) {
                try {
                    sess.queue.put(packet);
                }
                catch (Exception e) {
                    LoggingTools.tryLogFormatException((Logger)LOG, (LoggingDetailLevel)LogLevel.ERROR, (Throwable)e, (String)"Excepton ocurred while dispatching a package from the UB network at session `%s` the packet `%s`", (Object)sess, (Object)packet);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PacketEndpointQueue getSessionQueue() {
        RpcSession sess = RpcSessionTools.ensureGetCurrentRpcSession();
        Map map = sess.getExtraDataMap();
        PacketEndpointQueue pq = null;
        Set<PacketEndpointQueue> set = this.sessions;
        synchronized (set) {
            pq = (PacketEndpointQueue)map.get(this.sessionKey);
            if (null == pq) {
                pq = new PacketEndpointQueue();
                pq.rpcSession = sess;
                map.put(this.sessionKey, pq);
                this.sessions.add(pq);
            }
        }
        return pq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(byte[] data) throws IOException {
        this.sendPacket.publish((Object)data);
        Object[] objectArray = this.sessions;
        synchronized (this.sessions) {
            Object[] queues = this.sessions.toArray(PacketEndpointQueue.emptyPacketEndpointQueue);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (LOG.mayLog((LoggingDetailLevel)LogLevel.TRACE)) {
                LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.TRACE, (String)"sendPacket trying loopback on sessions: `%s`", (Object)Arrays.toString(queues));
            }
            for (Object sess : queues) {
                try {
                    if (!((PacketEndpointQueue)sess).loopback_send_packets) continue;
                    ((PacketEndpointQueue)sess).queue.put(data);
                }
                catch (Exception e) {
                    LoggingTools.tryLogFormatException((Logger)LOG, (LoggingDetailLevel)LogLevel.ERROR, (Throwable)e, (String)"Excepton ocurred while dispatching a loopback package at session `%s` the packet `%s`", (Object)sess, (Object)data);
                }
            }
            return;
        }
    }

    public Map<String, String> listAttributes() {
        return new OneShotMap((Object)"loopback_send_packets", (Object)"The call of `getNextPacket` functions returns also the you sent with `sendPacket`. Used to implement full network sniffing");
    }

    public String getAttribute(String key) {
        if ("loopback_send_packets".equals(key)) {
            return String.valueOf(this.getSessionQueue().loopback_send_packets);
        }
        return null;
    }

    public void setAttribute(String key, String value) {
        if ("loopback_send_packets".equals(key)) {
            Boolean set = (Boolean)CastTo.Boolean.cast((Object)value);
            if (null == set) {
                throw new RuntimeException("The given value `" + value + "` can not be casted to boolean.");
            }
            PacketEndpointQueue sess = this.getSessionQueue();
            LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"Set loopback 'loopback_send_packets' to `%s` for session `%s`", (Object)set, (Object)sess);
            sess.loopback_send_packets = set;
        }
    }

    public byte[] getNextPacket() throws IOException {
        try {
            return this.getSessionQueue().queue.take();
        }
        catch (InterruptedException e) {
            Mirror.propagateAnyway((Throwable)e);
            return null;
        }
    }

    public void close() throws IOException {
    }

    protected static class PacketEndpointQueue {
        public static final PacketEndpointQueue[] emptyPacketEndpointQueue = new PacketEndpointQueue[0];
        protected boolean loopback_send_packets = false;
        protected BlockingQueue<byte[]> queue = new LinkedBlockingQueue<byte[]>();
        protected RpcSession rpcSession;

        protected PacketEndpointQueue() {
        }
    }
}

