/*
 * Decompiled with CFR 0.152.
 */
package eu.uartbus.webapp;

import eu.javaexperience.electronic.uartbus.rpc.UartbusConnection;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import eu.javaexperience.rpc.JavaClassRpcUnboundFunctionsInstance;
import eu.javaexperience.rpc.RpcFacility;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.teasite.TeasiteBundle;
import eu.javaexperience.web.dom.build.WebSoftwareBundle;
import eu.javaexperience.web.template.WebsiteTemplate;
import eu.uartbus.webapp.backend.UbBackendTools;
import eu.uartbus.webapp.backend.connection.UartbusConnectionDistributorUnit;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Server;

public class UbWebServer {
    protected String siteName;
    protected int port;
    protected Class webappClass;
    protected TeasiteBundle teasite;
    protected WebsiteTemplate website;
    protected Server server;
    protected List<RpcFacility> rpcNodes = new ArrayList<RpcFacility>();

    public UbWebServer(String siteName, int port, @MayNull UartbusConnection ubc, Class appMain) throws IOException {
        this.siteName = siteName;
        this.port = port;
        this.webappClass = appMain;
        if (null != ubc) {
            this.addExtraConnection("uartbus", ubc);
        }
    }

    public void addExtraConnection(String namespace, UartbusConnection conn) throws IOException {
        this.addExtraApi((RpcFacility)new JavaClassRpcUnboundFunctionsInstance(namespace, (Object)UbWebServer.wrapPacketDistributor(conn).getDistributor(), new Class[]{UartbusConnection.class}));
    }

    public void addExtraApi(RpcFacility node) {
        String ns = node.getRpcName();
        for (RpcFacility n : this.rpcNodes) {
            if (!n.getRpcName().equals(ns)) continue;
            throw new RuntimeException("Rpc namespace `" + ns + "` already present.");
        }
        this.rpcNodes.add(node);
    }

    protected TeasiteBundle create() {
        if (UbBackendTools.isSystemInDevelMode()) {
            new File("src/main/resources/web_resources/site/").mkdirs();
        }
        return new TeasiteBundle("", UbBackendTools.isSystemInDevelMode(), UbBackendTools.resourceFile(UbBackendTools.isSystemInDevelMode() ? "src/main/resources/web_resources" : "web_resources"), "/tmp/" + this.siteName, UbBackendTools.resourceFile((UbBackendTools.isSystemInDevelMode() ? "src/main/resources/" : "") + "web_resources/site/" + this.siteName + "_webapp.js"), this.webappClass, this.createWebSoftwareBundles(), this.rpcNodes.toArray(new RpcFacility[0]));
    }

    protected WebSoftwareBundle[] createWebSoftwareBundles() {
        return null;
    }

    protected WebsiteTemplate createWebsite() {
        this.teasite.script.getScriptNode().setCheckModifiedOnRequest(UbBackendTools.isSystemInDevelMode());
        WebsiteTemplate.WebsiteTemplateTemplateBuilder b = WebsiteTemplate.WebsiteTemplateTemplateBuilder.createDefaults();
        b.handleApp = this.teasite.asPathDispatch();
        b.sessionCookieName = "jvx-" + this.siteName + "-session";
        return new WebsiteTemplate(b);
    }

    public void start() throws Exception {
        this.teasite = this.create();
        this.website = this.createWebsite();
        this.server = UbBackendTools.createServer((SimplePublish2<HttpServletRequest, HttpServletResponse>)((SimplePublish2)(req, resp) -> {
            try {
                this.website.service(req, resp);
            }
            catch (IOException | ServletException e) {
                e.printStackTrace();
            }
        }), this.port);
        this.server.start();
    }

    public static UartbusConnectionDistributorUnit wrapPacketDistributor(UartbusConnection conn) throws IOException {
        UartbusConnectionDistributorUnit ret = new UartbusConnectionDistributorUnit(conn);
        ret.start();
        return ret;
    }
}

