package eu.uartbus.webapp.modules.widget;

import org.teavm.jso.dom.events.KeyboardEvent;
import org.teavm.jso.dom.html.HTMLInputElement;
import org.teavm.jso.dom.xml.Element;

import eu.javaexperience.parse.ParsePrimitive;
import eu.javaexperience.patterns.behavioral.mediator.EventMediator;
import eu.jvx.js.lib.ImpersonalisedHtml;
import eu.jvx.js.lib.bindings.H;
import eu.jvx.js.lib.bindings.VanillaTools;

/*
	[ ids buttons ]
	[ show broadcasts ] [ clear ]
	[ add id ] [bnt]
*/
public class DeviceAddressesWidget implements ImpersonalisedHtml
{
	protected H root = new H("div");
	
	protected H ids = new H("div");
	
	protected boolean showBrodcastAddresses = false;
	protected H broadcasts = new H("input").attrs("type", "checkbox");
	
	protected H clear = new H("button").attrs("#text", "Clear", "style", "margin: 5px").onClick(e->clear());
	
	protected H newAddr = new H("input").attrs("type", "number");
	protected H addNew = new H("button").attrs("#text", "Add");
	
	protected EventMediator<Long> onIdSelect = new EventMediator<>();
	
	public DeviceAddressesWidget()
	{
		broadcasts.onClick(e->showBroadcastAddresses(((HTMLInputElement)broadcasts.getHtml()).isChecked()));
		
		newAddr.on("keyup", e->
		{
			KeyboardEvent event = (KeyboardEvent) e;
			if(event.getKeyCode() == 13)
			{
				processNewAddr();
			}
		});
		
		addNew.on("click", e->processNewAddr());
		
		root.addChilds
		(
			ids,
			new H("div").attrs("style", "margin: 5px").addChilds
			(
				new H("span").attrs("#text", "Show broadcast addresses: "),
				broadcasts,
				clear
			),
			new H("div").attrs("style", "margin: 5px").addChilds(newAddr, addNew.attrs("style", "margin: 5px"))
		);
	}
	
	protected void processNewAddr()
	{
		String cnt = VanillaTools.getContent(newAddr);
		VanillaTools.setContent(newAddr, "");
		Long val = ParsePrimitive.tryParseLong(cnt);
		if(null != val)
		{
			addAddress(val);
		}
	}
	
	public void showBroadcastAddresses(boolean show)
	{
		showBrodcastAddresses = show;
		if(show)
		{
			broadcasts.attrs("checked", "checked");
			for(H l:ids.listChilds())
			{
				l.getHtml().getStyle().setProperty("display", "inline-block");
			}
		}
		else
		{
			broadcasts.getHtml().removeAttribute("checked");
			for(H l:ids.listChilds())
			{
				if(ParsePrimitive.tryParseInt(VanillaTools.getContent(l)) > 0)
				{
					l.getHtml().getStyle().setProperty("display", "inline-block");
				}
				else
				{
					l.setVisible(false);
				}
			}
		}
	}
	
	public void clear()
	{
		ids.clear();
	}
	
	protected H createAddressButton(long id)
	{
		H ret = new H("div").attrs
		(
			"style", "display:inline-block; padding: 8px; margin: 5px; border-radius: 5px; background-color: lightgrey; border: 1px solid black",
			"#text", String.valueOf(id)
		);
		
		if(id < 1 && !showBrodcastAddresses)
		{
			ret.setVisible(false);
		}
		ret.onClick(e->onIdSelect.dispatchEvent(ParsePrimitive.tryParseLong(VanillaTools.getContent(ret))));
		return ret;
	}
	
	public void addAddress(long id)
	{
		for(H i:ids.listChilds())
		{
			long value = ParsePrimitive.tryParseLong(VanillaTools.getContent(i), 0);
			if(id == value)
			{
				return;
			}
			
			if(value > id)
			{
				ids.getHtml().insertBefore(createAddressButton(id).getHtml(), i.getHtml());
				return;
			}
		}
		
		ids.addChilds(createAddressButton(id));
		
	}
	
	public EventMediator<Long> getOnIdSelect()
	{
		return onIdSelect;
	}

	@Override
	public Object getImpersonator()
	{
		return this;
	}

	@Override
	public Element getHtml()
	{
		return root.getHtml();
	}
}
