/*
 * Decompiled with CFR 0.152.
 */
package eu.uartbus.webapp.backend;

import eu.javaexperience.file.AbstractFile;
import eu.javaexperience.file.AbstractFileSystem;
import eu.javaexperience.file.FileSystemTools;
import eu.javaexperience.file.fs.combined.CombinedFileSystem;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class UbBackendTools {
    protected static boolean IS_DEBUG = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
    public static final AbstractFileSystem FILESYSTEM = new CombinedFileSystem(UbBackendTools.collectFs().toArray(FileSystemTools.emptyAbstractFileSystemArray));

    public static void forceSetDevelopementMode(boolean mode) {
        IS_DEBUG = mode;
    }

    public static boolean isSystemInDevelMode() {
        return IS_DEBUG;
    }

    protected static List<AbstractFileSystem> collectFs() {
        List ret = FileSystemTools.collectJavaClassPathFileSystems();
        ret.add(FileSystemTools.SYSTEM_CLASSLOADER_FILESYSTEM);
        ret.add(FileSystemTools.DEFAULT_FILESYSTEM);
        return ret;
    }

    public static AbstractFile resourceFile(String file) {
        return (IS_DEBUG ? FileSystemTools.DEFAULT_FILESYSTEM : FILESYSTEM).fromUri(file);
    }

    public static Server createServer(final SimplePublish2<HttpServletRequest, HttpServletResponse> service, int port) throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server, 1, 1);
        connector.setPort(port);
        server.addConnector((Connector)connector);
        server.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                service.publish((Object)request, (Object)response);
            }
        });
        return server;
    }
}

