package eu.uartbus.webapp.frontend;

import java.io.Closeable;
import java.io.IOException;

import eu.javaexperience.electronic.uartbus.rpc.UartbusConnection;
import eu.javaexperience.electronic.uartbus.rpc.client.UartBus;
import eu.javaexperience.electronic.uartbus.rpc.client.UartbusStreamerEndpoint;
import eu.teasite.frontend.api.ApiClient;

public class FrontendUartBus implements Closeable
{
	protected UartbusStreamerEndpoint streamer;
	protected int fromAddress;
	
	public FrontendUartBus(UartbusConnection conn, int fromAddress)
	{
		streamer = new UartbusStreamerEndpoint(()->conn);
		this.fromAddress = fromAddress;
	}
	
	protected UartBus bus;
	
	public UartBus getBus()
	{
		if(null == bus)
		{
			streamer.startStreaming();
			bus = new UartBus
			(
				null,
				streamer::sendPacket,
				fromAddress
			);
			streamer.getPacketStreamer().addEventListener(bus::processPacket);
		}
		return bus;
	}
	
	public static FrontendUartBus connectApi(ApiClient api, String namespace, int fromAddress)
	{
		return new FrontendUartBus(api.getApiClass(UartbusApi.class, namespace), fromAddress);
	}

	@Override
	public void close() throws IOException
	{
		streamer.close();
	}
}
