package eu.uartbus.webapp.modules;

import eu.javaexperience.interfaces.simple.SimpleCall;
import eu.javaexperience.scheduler.periodic.RepeatTask;
import eu.jvx.js.lib.bindings.H;

public class RepeatActionButton
{
	protected H btn;
	protected RepeatTask action;
	
	public RepeatActionButton(String text, SimpleCall act)
	{
		this.action = new RepeatTask(act);
		btn = createButton(text);
		
		btn.onClick(e->
		{
			if(action.isRunning())
			{
				action.stop();
			}
			else
			{
				action.start();
			}

			if(action.isRunning())
			{
				btn.getHtml().getStyle().setProperty("background-color", "yellow");
			}
			else
			{
				btn.getHtml().getStyle().setProperty("background-color", "grey");
			}
		});
	}
	
	public static H createButton(String text)
	{
		return new H("button").attrs
		(
			"style", "border-radius: 5px; border: 1px solid black; padding: 5px; margin: 5px; background-color: grey",
			"#text", text
		);
	}
	
	public RepeatTask getController()
	{
		return action;
	}
	
	public void getInterval(int val)
	{
		this.action.setInterval(val);
	}
}
