/*
 * Decompiled with CFR 0.152.
 */
package eu.uartbus.webapp.modules;

import eu.javaexperience.electronic.uartbus.UartbusConsoleEnv;
import eu.javaexperience.electronic.uartbus.UartbusTools;
import eu.javaexperience.electronic.uartbus.rpc.client.UartBus;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.patterns.behavioral.mediator.EventMediator;
import eu.javaexperience.reflect.Mirror;
import eu.jvx.js.lib.bindings.H;
import eu.jvx.js.lib.bindings.VanillaTools;
import java.io.IOException;
import org.teavm.jso.dom.events.KeyboardEvent;
import org.teavm.jso.dom.html.HTMLElement;

public class UbWebConsole {
    protected H root;
    protected SimplePublish1<byte[]> sendPacket;
    protected H console = new H("div").attrs(new String[]{"style", "height: 300px;overflow: scroll;overflow-x: hidden;background-color: #eeeeee"});
    protected H clear = new H("button").attrs(new String[]{"#text", "Clear"}).on("click", e -> this.console.clear());
    protected H input = new H("input").attrs(new String[]{"type", "text"}).on("keyup", e -> {
        KeyboardEvent event = (KeyboardEvent)e;
        if (event.getKeyCode() == 13) {
            this.doSend();
        }
    });
    protected boolean echo = true;
    protected H send = new H("button").attrs(new String[]{"#text", "Send"}).on("click", e -> this.doSend());
    protected EventMediator<UartbusConsoleEnv.UbConsoleResponse> onAddressChanged = new EventMediator();
    protected UartbusConsoleEnv cmd = new UartbusConsoleEnv();

    public void reset() {
        this.cmd.setFromAddress(63);
        this.cmd.setToAddress(63);
        this.console.clear();
        VanillaTools.setContent((H)this.input, (String)"");
    }

    public UartbusConsoleEnv getConsole() {
        return this.cmd;
    }

    public void incomingPacket(byte[] data) {
        this.addText((UartbusTools.isPacketCrc8Valid((byte[])data) ? "" : "!") + UartbusTools.formatColonData((byte[])data));
    }

    public void addText(String text) {
        this.addContent(new H("div").attrs(new String[]{"#text", text}));
    }

    public void addContent(H content) {
        this.console.addChilds(new H[]{content});
        HTMLElement out = this.console.getHtml();
        out.setScrollTop(out.getScrollHeight() - out.getClientHeight());
    }

    public void doSend() {
        String in = VanillaTools.getContent((H)this.input);
        VanillaTools.setContent((H)this.input, (String)"");
        UartbusConsoleEnv.UbConsoleResponse ret = this.cmd.feed(in);
        switch (ret.getType()) {
            case NO_OP: {
                return;
            }
            case NEED_HELP: {
                this.printHelp();
                break;
            }
            case QUERY_ADDRESS_FROM: {
                this.addText("From address: " + this.cmd.getAddressFrom());
                this.onAddressChanged.dispatchEvent((Object)ret);
                break;
            }
            case QUERY_ADDRESS_TO: {
                this.addText("To address: " + this.cmd.getAddressTo());
                this.onAddressChanged.dispatchEvent((Object)ret);
                break;
            }
            case SEND_PACKET: {
                try {
                    byte[] packet = ret.toPacket();
                    System.out.println("send packet: " + UartbusTools.formatColonData((byte[])packet));
                    if (this.echo) {
                        this.addText("# " + UartbusTools.formatColonData((byte[])packet));
                    }
                    this.sendPacket.publish((Object)packet);
                }
                catch (IOException e) {
                    Mirror.propagateAnyway((Throwable)e);
                }
                break;
            }
            case UNKNOWN_COMMAND: {
                this.unrecognisedCmd(ret.getMessage());
                break;
            }
        }
    }

    public UbWebConsole(H root, SimplePublish1<byte[]> sendPacket) {
        this.root = root;
        this.sendPacket = sendPacket;
        root.addChilds(new H[]{this.console, new H("div").addChilds(new H[]{this.clear, this.input, this.send})});
        this.reset();
    }

    public static UbWebConsole connectToBus(H container, UartBus bus) {
        UbWebConsole ret = new UbWebConsole(container, (SimplePublish1<byte[]>)((SimplePublish1)p -> bus.sendRawPacket(p)));
        bus.getUnrelatedPacketListener().addEventListener(ret::incomingPacket);
        return ret;
    }

    protected void unrecognisedCmd(String message) {
        this.addText("Unrecognised command: " + message);
    }

    protected void printHelp() {
        StringBuilder sb = new StringBuilder();
        for (String s : UartbusConsoleEnv.HELP_LINES) {
            sb.append(s);
            sb.append("\n");
        }
        this.addContent(new H("pre").attrs(new String[]{"#text", sb.toString()}));
    }

    public boolean isEchoEnabled() {
        return this.echo;
    }

    public void setEcho(boolean echo) {
        this.echo = echo;
    }

    public EventMediator<UartbusConsoleEnv.UbConsoleResponse> getOnAddressChange() {
        return this.onAddressChanged;
    }
}

