/*
 * Decompiled with CFR 0.152.
 */
package eu.uartbus.webapp.modules.widget;

import eu.javaexperience.parse.ParsePrimitive;
import eu.javaexperience.patterns.behavioral.mediator.EventMediator;
import eu.jvx.js.lib.ImpersonalisedHtml;
import eu.jvx.js.lib.bindings.H;
import eu.jvx.js.lib.bindings.VanillaTools;
import org.teavm.jso.dom.events.KeyboardEvent;
import org.teavm.jso.dom.html.HTMLInputElement;
import org.teavm.jso.dom.xml.Element;
import org.teavm.jso.dom.xml.Node;

public class DeviceAddressesWidget
implements ImpersonalisedHtml {
    protected H root = new H("div");
    protected H ids = new H("div");
    protected boolean showBrodcastAddresses = false;
    protected H broadcasts = new H("input").attrs(new String[]{"type", "checkbox"});
    protected H clear = new H("button").attrs(new String[]{"#text", "Clear", "style", "margin: 5px"}).onClick(e -> this.clear());
    protected H newAddr = new H("input").attrs(new String[]{"type", "number"});
    protected H addNew = new H("button").attrs(new String[]{"#text", "Add"});
    protected EventMediator<Long> onIdSelect = new EventMediator();

    public DeviceAddressesWidget() {
        this.broadcasts.onClick(e -> this.showBroadcastAddresses(((HTMLInputElement)this.broadcasts.getHtml()).isChecked()));
        this.newAddr.on("keyup", e -> {
            KeyboardEvent event = (KeyboardEvent)e;
            if (event.getKeyCode() == 13) {
                this.processNewAddr();
            }
        });
        this.addNew.on("click", e -> this.processNewAddr());
        this.root.addChilds(new H[]{this.ids, new H("div").attrs(new String[]{"style", "margin: 5px"}).addChilds(new H[]{new H("span").attrs(new String[]{"#text", "Show broadcast addresses: "}), this.broadcasts, this.clear}), new H("div").attrs(new String[]{"style", "margin: 5px"}).addChilds(new H[]{this.newAddr, this.addNew.attrs(new String[]{"style", "margin: 5px"})})});
    }

    protected void processNewAddr() {
        String cnt = VanillaTools.getContent((H)this.newAddr);
        VanillaTools.setContent((H)this.newAddr, (String)"");
        Long val = ParsePrimitive.tryParseLong((String)cnt);
        if (null != val) {
            this.addAddress(val);
        }
    }

    public void showBroadcastAddresses(boolean show) {
        this.showBrodcastAddresses = show;
        if (show) {
            this.broadcasts.attrs(new String[]{"checked", "checked"});
            for (H l : this.ids.listChilds()) {
                l.getHtml().getStyle().setProperty("display", "inline-block");
            }
        } else {
            this.broadcasts.getHtml().removeAttribute("checked");
            for (H l : this.ids.listChilds()) {
                if (ParsePrimitive.tryParseInt((String)VanillaTools.getContent((H)l)) > 0) {
                    l.getHtml().getStyle().setProperty("display", "inline-block");
                    continue;
                }
                l.setVisible(false);
            }
        }
    }

    public void clear() {
        this.ids.clear();
    }

    protected H createAddressButton(long id) {
        H ret = new H("div").attrs(new String[]{"style", "display:inline-block; padding: 8px; margin: 5px; border-radius: 5px; background-color: lightgrey; border: 1px solid black", "#text", String.valueOf(id)});
        if (id < 1L && !this.showBrodcastAddresses) {
            ret.setVisible(false);
        }
        ret.onClick(e -> this.onIdSelect.dispatchEvent((Object)ParsePrimitive.tryParseLong((String)VanillaTools.getContent((H)ret))));
        return ret;
    }

    public void addAddress(long id) {
        for (H i : this.ids.listChilds()) {
            long value = ParsePrimitive.tryParseLong((String)VanillaTools.getContent((H)i), (long)0L);
            if (id == value) {
                return;
            }
            if (value <= id) continue;
            this.ids.getHtml().insertBefore((Node)this.createAddressButton(id).getHtml(), (Node)i.getHtml());
            return;
        }
        this.ids.addChilds(new H[]{this.createAddressButton(id)});
    }

    public EventMediator<Long> getOnIdSelect() {
        return this.onIdSelect;
    }

    public Object getImpersonator() {
        return this;
    }

    public Element getHtml() {
        return this.root.getHtml();
    }
}

