/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.dispatch.url;

import eu.javaexperience.generic.TimeAttrEntry;
import eu.javaexperience.web.dispatch.url.CachedSaltedContentUrlNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public abstract class ContentConcaterationURLNode
extends CachedSaltedContentUrlNode {
    protected abstract TimeAttrEntry<byte[]>[] getContentList();

    public ContentConcaterationURLNode(String name, String mime) {
        super(name, mime);
    }

    protected byte[] beforeContentUnit(TimeAttrEntry<byte[]> entry) {
        return null;
    }

    protected byte[] afterContentUnit(TimeAttrEntry<byte[]> entry) {
        return null;
    }

    @Override
    public byte[] loadContent() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TimeAttrEntry<byte[]>[] fs = this.getContentList();
        if (null != fs) {
            for (TimeAttrEntry<byte[]> sf : fs) {
                try {
                    byte[] before = this.beforeContentUnit(sf);
                    byte[] after = this.afterContentUnit(sf);
                    if (null != before) {
                        baos.write(before);
                    }
                    baos.write((byte[])sf.getSubject());
                    if (null == after) continue;
                    baos.write(after);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return baos.toByteArray();
    }

    @Override
    public long determineLastModified() {
        long lastModified = 0L;
        TimeAttrEntry<byte[]>[] fs = this.getContentList();
        if (null == fs) {
            return 0L;
        }
        for (TimeAttrEntry<byte[]> sf : fs) {
            long lm = sf.getLastModifiedTime();
            if (lm <= lastModified) continue;
            lastModified = lm;
        }
        return lastModified;
    }
}

