/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.dispatch.url;

import eu.javaexperience.arrays.ArrayTools;
import eu.javaexperience.collection.map.NullMap;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.text.StringTools;
import eu.javaexperience.url.UrlBuilder;
import eu.javaexperience.url.UrlTools;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class PreparedURL {
    protected PreparedURL original;
    protected int defaultPort;
    protected String protocol;
    protected String user;
    protected int port;
    protected String[] path;
    protected Map<String, String[]> params;
    protected int domainSize;
    protected int pathPointer = 0;
    protected String url = null;
    protected URL toUrl;

    public PreparedURL(URL url) {
        this.process(url);
    }

    public void setOriginal(PreparedURL purl) {
        this.original = purl;
    }

    public PreparedURL getOriginal() {
        return this.original;
    }

    public Map<String, String[]> getParams() {
        return this.params;
    }

    public String getParameter(String key) {
        String[] ret = this.params.get(key);
        if (null == ret) {
            return null;
        }
        if (ret.length > 0) {
            return ret[0];
        }
        return null;
    }

    public PreparedURL(String protocol, String user, String domain, int port, int defaultPort, String path, String params) {
        this.process(protocol, user, domain, port, defaultPort, path, params);
    }

    public PreparedURL(HttpServletRequest req) {
        this.process(req.getRequestURL().toString());
    }

    public PreparedURL(String protocol, String user, String domain, int port, int defaultPort, String path, Map<String, String[]> params) {
        this.process(protocol, user, domain, port, defaultPort, path, params);
    }

    protected void process(URL url) {
        this.process(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort() == -1 ? url.getDefaultPort() : url.getPort(), url.getDefaultPort(), url.getPath(), url.getQuery());
    }

    protected void process(String protocol, String user, String domain, int port, int defaultPort, String path, String params) {
        this.process(protocol, user, domain, port, defaultPort, path, params == null ? null : UrlTools.resolvMap((String)params));
    }

    private void process(String url) {
        try {
            this.process(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private void process(String protocol, String user, String domain, int port, int defaultPort, String path, Map<String, String[]> params) {
        this.protocol = protocol;
        this.user = user;
        this.port = port;
        this.defaultPort = defaultPort;
        Object[] doma = UrlTools.domSplit.split(domain);
        this.domainSize = doma.length;
        Object[] paths = StringTools.whitoutNullAndEmptyString((String[])UrlTools.pathSplit.split(path));
        UrlTools.modifyUrlDecode((String[])paths);
        if (doma.length > 0) {
            ArrayTools.modifyReverse((Object[])doma);
        }
        this.path = doma.length == 0 ? paths : (String[])ArrayTools.arrayConcat((Object[])doma, (Object[])paths);
        this.params = null != params ? params : NullMap.instance;
    }

    public int getDomainElements() {
        return this.domainSize;
    }

    public boolean isPointerValid() {
        return this.path.length > this.pathPointer;
    }

    public int getRemainElementNum() {
        return this.path.length - this.pathPointer;
    }

    public int getUrlLength() {
        return this.path.length;
    }

    public int getUrlPointer() {
        return this.pathPointer;
    }

    public String getCurrentURLElement() {
        if (this.pathPointer >= this.path.length) {
            return null;
        }
        return this.path[this.pathPointer];
    }

    public String getNextURLElement() {
        return this.path[this.pathPointer + 1];
    }

    public void jumpNextURLElement(int n) {
        this.pathPointer += n;
    }

    public String getNextURLElement(int n) {
        return this.path[this.pathPointer + n];
    }

    public boolean hasNextURLElement() {
        return this.pathPointer < this.path.length - 1;
    }

    public boolean hasPerviousURLElement() {
        return this.pathPointer > 0;
    }

    public String previousURLElement() {
        return this.path[this.pathPointer - 1];
    }

    public String previousURLElement(int n) {
        return this.path[this.pathPointer - n];
    }

    public String getURLElementAndJumpNext() {
        return this.path[this.pathPointer++];
    }

    public int getURLElementIndex() {
        return this.pathPointer;
    }

    public void jumpNextURLElement() {
        ++this.pathPointer;
    }

    public String tryGetNextURLElement() {
        if (this.pathPointer - 1 < this.path.length) {
            return this.path[this.pathPointer + 1];
        }
        return null;
    }

    public String tryGetCurrentURLElement() {
        if (this.pathPointer < this.path.length) {
            return this.path[this.pathPointer];
        }
        return null;
    }

    public List<String> asList() {
        return Arrays.asList(this.path);
    }

    public Iterator<String> iterator() {
        return Arrays.asList(this.path).iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.path.length; ++i) {
            if (i == this.pathPointer) {
                sb.append("'");
            } else {
                sb.append("\"");
            }
            sb.append(this.path[i]);
            if (i == this.pathPointer) {
                sb.append("' ");
                continue;
            }
            sb.append("\" ");
        }
        return sb.toString();
    }

    public boolean isEndOfPath() {
        return !this.isPointerValid();
    }

    public String getDomainOnly() {
        StringBuilder sb = new StringBuilder();
        this.buildDomain(sb);
        return sb.toString();
    }

    protected void buildDomain(StringBuilder sb) {
        for (int i = this.domainSize - 1; i >= 0; --i) {
            if (i != this.domainSize - 1) {
                sb.append(".");
            }
            sb.append(this.path[i]);
        }
    }

    public String getUrl() {
        if (null == this.url) {
            this.url = this.getUrl(Integer.MAX_VALUE, true);
        }
        return this.url;
    }

    public URL toUrl() {
        if (null == this.toUrl) {
            try {
                this.toUrl = new URL(this.getUrl());
            }
            catch (MalformedURLException e) {
                Mirror.throwSoftOrHardButAnyway((Throwable)e);
            }
        }
        return this.toUrl;
    }

    public UrlBuilder toBuilder() {
        return new UrlBuilder(this.getUrl());
    }

    public static void main(String[] args) throws Throwable {
        PreparedURL purl = new PreparedURL(new URL("http://szupervigyor:david@sites.ddsi.hu/site/page/?paramG&paramA=b&paramB=v"));
        System.out.println(purl.getUrl());
    }

    public void jumpPrevURLElement() {
        --this.pathPointer;
    }

    public String getPath() {
        return this.toUrl().getPath();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getPort() {
        return this.port;
    }

    @MayNull
    public String atPath(int index) {
        if ((index += this.domainSize) < 0 || index >= this.path.length) {
            return null;
        }
        return this.path[index];
    }

    public String getUri() {
        return this.getUrl();
    }

    public String getQuery() {
        StringBuilder sb = new StringBuilder();
        UrlTools.renderRequestParams(this.params, (Appendable)sb);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUrl(int urlPointer, boolean reqParam) {
        StringBuilder sb;
        block12: {
            int i;
            sb = new StringBuilder();
            int m = 0;
            sb.append(this.protocol);
            sb.append("://");
            try {
                for (i = this.domainSize - 1; i >= 0; --i) {
                    if (i != this.domainSize - 1) {
                        sb.append(".");
                    }
                    sb.append(this.path[i]);
                    if (++m < urlPointer) {
                        continue;
                    }
                    break block12;
                }
            }
            finally {
                if (this.port > 1 && this.port != this.defaultPort) {
                    sb.append(":");
                    sb.append(this.port);
                }
            }
            for (i = this.domainSize; i < this.path.length; ++i) {
                sb.append("/");
                sb.append(this.path[i]);
                if (++m < urlPointer) {
                    continue;
                }
                break block12;
            }
            if (this.domainSize == this.path.length) {
                sb.append("/");
            }
            if (reqParam) {
                UrlTools.renderRequestParams(this.params, (Appendable)sb);
            }
        }
        return sb.toString();
    }

    public void setPathPointer(int num) {
        this.pathPointer = num;
    }

    public int getPathPointer() {
        return this.pathPointer;
    }

    public String getRemainingPath() {
        int from = this.domainSize;
        if (this.pathPointer > from) {
            from = this.pathPointer;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = from; i < this.path.length; ++i) {
            sb.append("/");
            sb.append(this.path[i]);
        }
        return sb.toString();
    }

    public String getLast() {
        return this.path[this.path.length - 1];
    }
}

