/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.dispatch.url;

import eu.javaexperience.arrays.ArrayTools;
import eu.javaexperience.collection.iterator.ArrayIterator;
import eu.javaexperience.dispatch.Dispatcher;
import eu.javaexperience.semantic.references.MayNotModified;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.RequestContext;
import eu.javaexperience.web.dispatch.url.MultiUrlNodePattern;
import eu.javaexperience.web.dispatch.url.PreparedURL;
import eu.javaexperience.web.dispatch.url.URLLink;
import eu.javaexperience.web.dispatch.url.URLNodePattern;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class URLNode
implements URLLink,
Dispatcher<Context> {
    String nodeName;
    protected boolean isDomainNode = false;
    public static final URLNode[] emptyURLNodeArray = new URLNode[0];
    public static final URLLink[] emptyURLLinkArray = new URLLink[0];
    protected URLNode[] childs = emptyURLNodeArray;
    protected URLNode[] parents = emptyURLNodeArray;
    protected URLNodePattern pattern;

    public URLNodePattern getPattern() {
        return this.pattern;
    }

    public void setURLNodePattern(URLNodePattern patt) {
        this.pattern = patt;
    }

    protected URLNode() {
    }

    public URLNode getFistParent() {
        if (this.parents.length == 0) {
            return null;
        }
        return this.parents[0];
    }

    public final int depth() {
        int i = 0;
        URLNode n = this;
        while (n != null) {
            n = n.getFistParent();
            ++i;
        }
        return i;
    }

    public URLNode(String nodeName) {
        this.nodeName = nodeName;
        this.pattern = MultiUrlNodePattern.simpleCaseSensitiveString(nodeName);
    }

    public URLNode(String nodeName, boolean caseSensitive) {
        this.nodeName = nodeName;
        this.pattern = caseSensitive ? MultiUrlNodePattern.simpleCaseSensitiveString(nodeName) : MultiUrlNodePattern.simpleCaseInsensitiveString(nodeName);
    }

    public URLNode(String nodeName, Pattern regex) {
        this.nodeName = nodeName;
        this.pattern = MultiUrlNodePattern.fromRegex(regex);
    }

    public final boolean canHandleRequest(Context ctx) {
        return this.pattern.match(ctx);
    }

    public boolean shallFinishRequest(RequestContext ctx) {
        return ctx.getRequestUrl().getRemainElementNum() < 1;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    @MayNotModified
    public URLNode[] childs() {
        return this.childs;
    }

    @Override
    @MayNotModified
    public URLNode[] parents() {
        return this.parents;
    }

    public void removeChild(URLNode node) {
        for (URLNode n : this.childs) {
            if (!node.equals(n)) continue;
            this.childs = (URLNode[])ArrayTools.withoutElementIdentically((Object[])this.childs, (Object)node);
            node.parents = (URLNode[])ArrayTools.withoutElementIdentically((Object[])node.parents, (Object)this);
            break;
        }
    }

    public void addChild(URLNode node) {
        if (node == null) {
            return;
        }
        for (URLNode n : this.childs) {
            if (!node.equals(n)) continue;
            return;
        }
        this.childs = (URLNode[])ArrayTools.arrayAppend((Object[])this.childs, (Object)node);
        node.parents = (URLNode[])ArrayTools.arrayAppend((Object[])node.parents, (Object)this);
    }

    public boolean dispatch(Context ctx) {
        return this.tryDispatchSubNodes(ctx);
    }

    public boolean tryDispatchSubNodes(Context ctx) {
        PreparedURL url = ctx.getRequestUrl();
        String node = url.getCurrentURLElement();
        if (null == node) {
            return false;
        }
        if (ctx.getRequestUrl().isPointerValid()) {
            for (URLNode ch : this.childs) {
                if (!node.equals(ch.getNodeName())) continue;
                url.jumpNextURLElement();
                ch.dispatch(ctx);
                url.jumpPrevURLElement();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isDomainNode() {
        return this.isDomainNode;
    }

    public void setDomainNode(boolean dom) {
        this.isDomainNode = dom;
    }

    public String getPathWithDomain(@MayNull URLLink[] opt) {
        URLLink[] lst = opt == null ? this.getRawPath() : opt;
        int ni = 0;
        for (int i = 0; i < lst.length; ++i) {
            if (lst[i] != null) continue;
            ni = i;
            break;
        }
        StringBuilder path = new StringBuilder();
        for (int i = ni - 1; i > -1; --i) {
            path.append("/");
            path.append(lst[i].getNodeName());
        }
        StringBuilder domain = new StringBuilder();
        for (int i = ni + 1; i < lst.length; ++i) {
            if (domain.length() > 0) {
                domain.append(".");
            }
            domain.append(lst[i].getNodeName());
        }
        return domain.toString() + path.toString();
    }

    public static String getDomain(URLLink[] lst) {
        int ni = 0;
        for (int i = 0; i < lst.length; ++i) {
            if (lst[i] != null) continue;
            ni = i;
            break;
        }
        StringBuilder domain = new StringBuilder();
        for (int i = ni + 1; i < lst.length; ++i) {
            if (domain.length() > 0) {
                domain.append(".");
            }
            domain.append(lst[i].getNodeName());
        }
        return domain.toString();
    }

    public static String getPath(URLLink[] lst) {
        int ni = lst.length;
        for (int i = 0; i < lst.length; ++i) {
            if (lst[i] != null) continue;
            ni = i;
            break;
        }
        StringBuilder path = new StringBuilder();
        for (int i = ni - 1; i > -1; --i) {
            path.append("/");
            path.append(lst[i].getNodeName());
        }
        return path.toString();
    }

    public String getPath() {
        URLLink[] lst = this.getRawPath();
        StringBuilder sb = new StringBuilder();
        int sn = lst.length - 1;
        boolean ps = false;
        for (int i = sn; i > -1; --i) {
            URLLink n = lst[i];
            if (n == null) {
                ps = true;
                continue;
            }
            if (!ps) continue;
            sb.append("/");
            sb.append(n.getNodeName());
        }
        return sb.toString();
    }

    public URLLink[] getRawPath() {
        ArrayList<URLLink> path = new ArrayList<URLLink>();
        this.appendRawURLPath(path, false, false);
        return path.toArray(emptyURLNodeArray);
    }

    protected String appendRawURLPath(List<URLLink> list, boolean nullAdded, boolean generateUrl) {
        if (this.isDomainNode && !nullAdded) {
            list.add(null);
            nullAdded = true;
        }
        list.add(this);
        if (this.parents.length != 0) {
            return this.parents[0].appendRawURLPath(list, nullAdded, generateUrl);
        }
        return this.processCanonicalUrl(list);
    }

    protected String processCanonicalUrl(List<URLLink> nodes) {
        URLLink[] lnk = nodes.toArray(emptyURLLinkArray);
        String path = URLNode.getPath(lnk);
        return path.toString();
    }

    @Override
    public Iterator<URLLink> iterateOwnedElements() {
        return new ArrayIterator((Object[])this.childs);
    }

    @Override
    public String getCanonicalURL() {
        return this.appendRawURLPath(new ArrayList<URLLink>(), false, true);
    }

    public String toString() {
        return "URLNode: " + this.getNodeName();
    }
}

