/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.session;

import eu.javaexperience.interfaces.simple.SimpleCall;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.Session;
import eu.javaexperience.web.SessionManager;
import eu.javaexperience.web.SessionManagerTools;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class InMemorySessionManager
implements SessionManager {
    protected ConcurrentMap<String, Session> sessions = new ConcurrentHashMap<String, Session>();
    public final SimpleCall sessionDestroyer = new SimpleCall(){

        public void call() {
            for (Map.Entry kv : InMemorySessionManager.this.sessions.entrySet()) {
                Session sess = (Session)kv.getValue();
                if (sess == null || sess.validUntil() <= -1L || sess.validUntil() < System.currentTimeMillis()) continue;
                InMemorySessionManager.this.sessions.remove(kv.getKey());
                try {
                    sess.invalidate();
                }
                catch (Exception exception) {}
            }
        }
    };

    @Override
    public void destroySession(String str) {
        Session sess = (Session)this.sessions.remove(str);
        if (sess != null) {
            sess.invalidate();
        }
    }

    @Override
    public String registerSession(Session sess) {
        return SessionManagerTools.assignSessionId(sess, this.sessions);
    }

    @Override
    public String getSessionStringBySession(Session sess) {
        for (Map.Entry kv : this.sessions.entrySet()) {
            if (!sess.equals(kv.getValue())) continue;
            return (String)kv.getKey();
        }
        return null;
    }

    public Session getSiteObjectSession(String cookieName, HttpServletRequest req) {
        Cookie[] co = req.getCookies();
        if (co != null) {
            for (Cookie c : co) {
                if (!cookieName.equals(c.getName())) continue;
                return (Session)this.sessions.get(c.getValue());
            }
        }
        return null;
    }

    @Override
    public Session getSessionById(String id) {
        return (Session)this.sessions.get(id);
    }

    @Override
    public void destroySession(Context ctx) {
    }

    @Override
    public Set<Map.Entry<String, Session>> listAllSession() {
        return this.sessions.entrySet();
    }

    @Override
    public void addSessionWithId(String sessionCookieValue, Session sess) {
        this.sessions.put(sessionCookieValue, sess);
    }
}

