/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.text.Format;
import eu.javaexperience.url.UrlBuilder;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.HttpResponseStatusCode;
import eu.javaexperience.web.MIME;
import java.io.IOException;
import java.io.OutputStream;
import java.text.Normalizer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpTools {
    public static final Format.DateFormatParseUnit cookieFormat1 = new CookieDateFormatParseUnit("EEE, dd-MMM-yyyy HH:mm:ss z");
    public static final Format.DateFormatParseUnit cookieFormat2 = new CookieDateFormatParseUnit("EEE, dd MMM yyyy HH:mm:ss zzz");
    public static final Cookie[] emptyCookieArray = new Cookie[0];
    public static final String commentCookieSet = "putCookieForBrowser";

    public static boolean isPost(HttpServletRequest req) {
        return "POST".equalsIgnoreCase(req.getMethod());
    }

    public static boolean isGet(HttpServletRequest req) {
        return "GET".equalsIgnoreCase(req.getMethod());
    }

    public static boolean isHead(HttpServletRequest req) {
        return "HEAD".equalsIgnoreCase(req.getMethod());
    }

    public static boolean isPut(HttpServletRequest req) {
        return "PUT".equalsIgnoreCase(req.getMethod());
    }

    public static boolean isDelete(HttpServletRequest req) {
        return "DELETE".equalsIgnoreCase(req.getMethod());
    }

    public static boolean isTrace(HttpServletRequest req) {
        return "TRACE".equalsIgnoreCase(req.getMethod());
    }

    public static boolean isOptions(HttpServletRequest req) {
        return "OPTIONS".equalsIgnoreCase(req.getMethod());
    }

    public static boolean isConnect(HttpServletRequest req) {
        return "CONNECT".equalsIgnoreCase(req.getMethod());
    }

    public static boolean isPath(HttpServletRequest req) {
        return "PATH".equalsIgnoreCase(req.getMethod());
    }

    public static boolean isPost(Context ctx) {
        return "POST".equalsIgnoreCase(ctx.getRequest().getMethod());
    }

    public static boolean isGet(Context ctx) {
        return "GET".equalsIgnoreCase(ctx.getRequest().getMethod());
    }

    public static boolean isHead(Context ctx) {
        return "HEAD".equalsIgnoreCase(ctx.getRequest().getMethod());
    }

    public static boolean isPut(Context ctx) {
        return "PUT".equalsIgnoreCase(ctx.getRequest().getMethod());
    }

    public static boolean isDelete(Context ctx) {
        return "DELETE".equalsIgnoreCase(ctx.getRequest().getMethod());
    }

    public static boolean isTrace(Context ctx) {
        return "TRACE".equalsIgnoreCase(ctx.getRequest().getMethod());
    }

    public static boolean isOptions(Context ctx) {
        return "OPTIONS".equalsIgnoreCase(ctx.getRequest().getMethod());
    }

    public static boolean isConnect(Context ctx) {
        return "CONNECT".equalsIgnoreCase(ctx.getRequest().getMethod());
    }

    public static boolean isPath(Context ctx) {
        return "PATH".equalsIgnoreCase(ctx.getRequest().getMethod());
    }

    public static void sendMime(HttpServletResponse resp, MIME mime, byte[] data) throws IOException {
        resp.setContentType(mime.mime);
        resp.setContentLength(data.length);
        ServletOutputStream os = resp.getOutputStream();
        os.write(data);
        os.flush();
    }

    public static String getCookieValue(HttpServletRequest req, String cookieName) {
        return HttpTools.getCookieValue(req.getCookies(), cookieName);
    }

    public static String getCookieValue(Cookie[] cookies, String cookieName) {
        if (null == cookies || null == cookieName) {
            return null;
        }
        for (Cookie c : cookies) {
            if (!cookieName.equals(c.getName())) continue;
            return c.getValue();
        }
        return null;
    }

    public static String[] getCookieValues(Context ctx, String cookieName) {
        return HttpTools.getCookieValues(ctx.getRequest().getCookies(), cookieName);
    }

    public static String[] getCookieValues(HttpServletRequest req, String cookieName) {
        return HttpTools.getCookieValues(req.getCookies(), cookieName);
    }

    public static String[] getCookieValues(Cookie[] cookies, String cookieName) {
        if (null == cookies || null == cookieName) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (Cookie c : cookies) {
            if (!cookieName.equals(c.getName())) continue;
            ret.add(c.getValue());
        }
        return ret.toArray(Mirror.emptyStringArray);
    }

    public static void httpRedirect(HttpServletResponse resp, String path, boolean permanently) {
        resp.addHeader("Location", path);
        if (permanently) {
            resp.setStatus(HttpResponseStatusCode._301_moved_permanently.getStatus());
        } else {
            resp.setStatus(HttpResponseStatusCode._307_temporary_redirect.getStatus());
        }
    }

    public static ZipOutputStream createZipOutputToClient(String filename, HttpServletResponse response) throws IOException {
        response.setContentType("application/x-zip");
        response.addHeader("Content-Transfer-Encoding", "binary");
        response.addHeader("Content-Disposition", "attachment; filename=" + filename);
        response.flushBuffer();
        ZipOutputStream zos = new ZipOutputStream((OutputStream)response.getOutputStream());
        return zos;
    }

    public static void tryRecogniseCookieHeader(Collection<Cookie> dst, String header, String value) {
        if ("cookie".equalsIgnoreCase(header)) {
            String[] cs;
            for (String c : cs = value.split(";")) {
                String[] kv = c.split("=", 2);
                if (kv.length != 2) continue;
                dst.add(new Cookie(kv[0].trim(), kv[1].trim()));
            }
        }
    }

    public static String headerFriendly(String k) {
        StringBuilder sb = new StringBuilder();
        k = k.toLowerCase();
        int l = k.length();
        boolean nextUpper = true;
        for (int i = 0; i < l; ++i) {
            char c = k.charAt(i);
            if (nextUpper) {
                sb.append(Character.toUpperCase(c));
                nextUpper = false;
                continue;
            }
            if (c == ' ' || c == '_') {
                nextUpper = true;
                sb.append("-");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static Map<String, String[]> convMapToMulti(Map<String, String> params) {
        SmallMap ret = new SmallMap();
        for (Map.Entry<String, String> p : params.entrySet()) {
            String[] stringArray;
            String v = p.getValue();
            String string = p.getKey();
            if (null == v) {
                stringArray = Mirror.emptyStringArray;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = v;
            }
            ret.put((Object)string, (Object)stringArray);
        }
        return ret;
    }

    public static Map<String, String> convertFromMultiToMap(Map<String, String[]> params) {
        SmallMap ret = new SmallMap();
        for (Map.Entry<String, String[]> p : params.entrySet()) {
            String[] v = p.getValue();
            if (null == v || v.length <= 0) continue;
            ret.put((Object)p.getKey(), (Object)v[0]);
        }
        return ret;
    }

    public static String cookieToHeaderLine(Cookie c, boolean lineEndRN) {
        StringBuilder sb = new StringBuilder();
        sb.append("Set-Cookie: ");
        sb.append(c.getName());
        sb.append("=");
        sb.append(c.getValue());
        if (c.getDomain() != null) {
            sb.append("; Domain=");
            sb.append(c.getDomain());
        }
        if (c.getPath() != null) {
            sb.append("; Path=");
            sb.append(c.getPath());
        }
        if (c.getMaxAge() > 0) {
            sb.append("; Expires=");
            sb.append(HttpTools.toHeaderDate(System.currentTimeMillis() + (long)(c.getMaxAge() * 1000)));
        }
        if (lineEndRN) {
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public static String renderCookie(Cookie c, boolean lineEndRN) {
        StringBuilder sb = new StringBuilder();
        sb.append(c.getName());
        sb.append("=");
        sb.append(c.getValue());
        if (c.getDomain() != null) {
            sb.append("; Domain=");
            sb.append(c.getDomain());
        }
        if (c.getPath() != null) {
            sb.append("; Path=");
            sb.append(c.getPath());
        }
        if (c.getMaxAge() > 0) {
            sb.append("; Expires=");
            sb.append(HttpTools.toHeaderDate(System.currentTimeMillis() + (long)(c.getMaxAge() * 1000)));
        }
        if (lineEndRN) {
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public static Date fromHeaderDate(String head) throws ParseException {
        try {
            return cookieFormat1.parse(head);
        }
        catch (Exception exception) {
            return cookieFormat2.parse(head);
        }
    }

    public static String toHeaderDate(long time) {
        return cookieFormat2.format(new Date(time));
    }

    public static String toHeaderDate(Date time) {
        return cookieFormat2.format(time);
    }

    public static HttpResponseStatusCode httpResponseByNumber(int num) {
        for (HttpResponseStatusCode r : HttpResponseStatusCode.values()) {
            if (r.getStatus() != num) continue;
            return r;
        }
        throw new IllegalArgumentException(num + " status code does not exist. See " + HttpResponseStatusCode.class.getName());
    }

    public static long getWebDate(Date date) {
        return date.getTime() / 1000L * 1000L;
    }

    public static long getWebDate(long date) {
        return date / 1000L * 1000L;
    }

    public static long getWebDateNow() {
        return System.currentTimeMillis() / 1000L * 1000L;
    }

    public static String toCacheSaltHexa(long d) {
        return Long.toHexString(d /= 1000L);
    }

    public static String toSeo(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "").replaceAll("[^\\p{Alnum}]+", "-");
    }

    public static UrlBuilder createBuilderFromUrl(HttpServletRequest req) {
        return new UrlBuilder(req.getRequestURL().toString());
    }

    protected static class CookieDateFormatParseUnit
    extends Format.DateFormatParseUnit {
        public CookieDateFormatParseUnit(String format) {
            super(format);
        }

        protected SimpleDateFormat create(String format) {
            SimpleDateFormat ret = new SimpleDateFormat(format, Locale.US);
            ret.setTimeZone(TimeZone.getTimeZone("GMT"));
            return ret;
        }
    }
}

