/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.dispatch.url;

import eu.javaexperience.web.Context;
import eu.javaexperience.web.dispatch.url.PreparedURL;
import eu.javaexperience.web.dispatch.url.URLNode;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class MultiStartWithUrlNode
extends URLNode {
    protected boolean resetPointer;
    protected ArrayList<PreparedURL> matchers = new ArrayList();

    public MultiStartWithUrlNode(boolean resetPointer, URL ... starts) {
        this.resetPointer = resetPointer;
        for (URL u : starts) {
            this.matchers.add(new PreparedURL(u));
        }
    }

    @Override
    public boolean dispatch(Context ctx) {
        PreparedURL req = ctx.getRequestUrl();
        Iterator<PreparedURL> iterator = this.matchers.iterator();
        if (iterator.hasNext()) {
            PreparedURL matcher = iterator.next();
            if (req.path.length < matcher.path.length || req.domainSize != matcher.domainSize) {
                return false;
            }
            String[] a = matcher.path;
            String[] b = req.path;
            for (int i = 0; i < a.length; ++i) {
                if (a[i].equals(b[i])) continue;
                return false;
            }
            if (this.resetPointer) {
                req.pathPointer = a.length;
            }
            return this.onMatch(ctx);
        }
        return false;
    }

    public abstract boolean onMatch(Context var1);
}

