/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.dispatch.url;

import eu.javaexperience.generic.TimeAttrEntry;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.HttpTools;
import eu.javaexperience.web.dispatch.url.ContentCompression;
import eu.javaexperience.web.dispatch.url.URLNode;
import eu.javaexperience.web.facility.SiteFacilityTools;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public abstract class SimpleCachedContentUrlNode
extends URLNode
implements TimeAttrEntry<byte[]> {
    protected boolean validForever;
    protected String allowed_other_sites = null;

    public void allowOtherSite(String allow) {
        this.allowed_other_sites = allow;
    }

    public SimpleCachedContentUrlNode(String nodeName) {
        super(nodeName);
    }

    public SimpleCachedContentUrlNode(String nodeName, boolean caseSensitive, boolean validForever) {
        super(nodeName, caseSensitive);
        this.validForever = validForever;
    }

    public SimpleCachedContentUrlNode(String nodeName, Pattern regex, boolean validForever) {
        super(nodeName, regex);
        this.validForever = validForever;
    }

    public void setValidForever(boolean forever) {
        this.validForever = forever;
    }

    public boolean isValidForever() {
        return this.validForever;
    }

    public abstract long getLastModified();

    public abstract byte[] getContent();

    public abstract String getMimeType();

    @Override
    public boolean dispatch(Context ctx) {
        HttpServletResponse resp = ctx.getResponse();
        if (null != this.allowed_other_sites) {
            ctx.getResponse().addHeader("Access-Control-Allow-Origin", this.allowed_other_sites);
        }
        long mod = HttpTools.getWebDate(this.getLastModified());
        if (this.validForever) {
            SiteFacilityTools.setItemValidForever(ctx);
        }
        if (!SiteFacilityTools.isContentModified(ctx, mod)) {
            SiteFacilityTools.sendItemNotModified(ctx);
        }
        SiteFacilityTools.setItemLastModified(ctx, mod);
        resp.setContentType(this.getMimeType());
        byte[] cont = this.getContent();
        resp.setContentLength(cont.length);
        try {
            ctx.getResponse().addHeader("Vary", "Accept-Encoding");
            ContentCompression cc = ContentCompression.recognise(ctx.getRequest());
            cc.sendContent(resp, cont);
            ServletOutputStream os = resp.getOutputStream();
            os.flush();
            os.close();
        }
        catch (Exception e) {
            Mirror.propagateAnyway((Throwable)e);
        }
        ctx.finishOperation();
        return true;
    }

    public long getLastModifiedTime() {
        return this.getLastModified();
    }

    public byte[] getSubject() {
        return this.getContent();
    }

    public Object getOrigin() {
        return this;
    }
}

