/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.dom.build;

import eu.javaexperience.web.dom.build.CPathBuilder;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CPathExpression {
    private static String txt = "\\\"(?<txt>[^\"]*)\\\"";
    public static final String example = "html > { head > meta.a.b | body > {div#tartalom.fullwidth[data-swgui='valami'][data-sw=\"v\"] > h1\"Hell\u00f3 \"  > h2\"vil\u00e1g.\"| input[disabled] | a[href]\"Valami\" | div#foot.transparent[data_swgui=v mi]}}";
    static final Pattern classesInTag = Pattern.compile("(\\.(?<cls>[\\w-_]+))");
    static final Pattern attrInTag = Pattern.compile("(\\[\\s*(?<quok>['\"]?)(?<k>" + CPathExpression.escapedString("quok") + ")(\\k<quok>)\\s*(=\\s*(?<quo>['\"]?)(?<v>" + CPathExpression.escapedString("quo") + ")(\\k<quo>))?\\])");
    static final Pattern tag = Pattern.compile("\\s*(?<name>\\w+)(#(?<id>\\w+))?((" + txt + ")|(" + classesInTag.toString() + ")|(" + attrInTag.toString() + "))*\\s*");
    protected static final Pattern FULLTAG = Pattern.compile("(?<tag>" + tag.toString() + ")|(\\s*(?<chr>[{}|>])\\s*)");

    static String escapedString(String groupName) {
        return "[^\"'\\]]+";
    }

    public static <T> T parseSingleElement(CPathBuilder<T> builder, String element) {
        String txt;
        T elem = null;
        Matcher t = tag.matcher(element);
        Object ref = null;
        String disz = null;
        if (t.find()) {
            disz = t.group();
            String constr = t.group("name");
            if (constr == null) {
                return null;
            }
            if (elem == null) {
                T t2 = builder.createTag(constr);
                elem = t2;
                ref = t2;
            } else {
                T t3 = builder.createTag(constr);
                ref = t3;
                builder.addChild(elem, t3);
            }
        }
        if (ref == null) {
            return null;
        }
        String id = t.group("id");
        if (null != id) {
            builder.setId(ref, id);
        }
        if (null != (txt = t.group("txt"))) {
            builder.setText(ref, txt);
        }
        Matcher dat = classesInTag.matcher(disz);
        while (dat.find()) {
            String cls = dat.group("cls");
            if (null == cls) continue;
            builder.addClass(ref, cls);
        }
        dat = attrInTag.matcher(disz);
        while (dat.find()) {
            String k = dat.group("k");
            String v = dat.group("v");
            if (null == k) continue;
            builder.addAttribute(ref, k, v);
        }
        return elem;
    }

    public static <T> T parse(CPathBuilder<T> builder, String str) {
        Matcher m = FULLTAG.matcher(str);
        T first = null;
        Stack<T> stack = new Stack<T>();
        boolean multi = false;
        boolean chld = false;
        boolean shib = false;
        boolean pending = false;
        String tag = null;
        String chr = null;
        try {
            while (m.find()) {
                tag = m.group("tag");
                if (tag != null) {
                    if (chld && !multi) {
                        pending = true;
                    } else if (!chld && pending) {
                        stack.pop();
                        pending = false;
                    } else {
                        pending = false;
                    }
                    if (first == null) {
                        T t = CPathExpression.parseSingleElement(builder, tag);
                        first = t;
                        stack.add(t);
                    }
                    if (shib) {
                        stack.pop();
                        stack.add(CPathExpression.parseSingleElement(builder, tag));
                        builder.addChild(stack.get(stack.size() - 2), stack.lastElement());
                        continue;
                    }
                    if (!chld) continue;
                    stack.add(CPathExpression.parseSingleElement(builder, tag));
                    builder.addChild(stack.get(stack.size() - 2), stack.lastElement());
                    continue;
                }
                chr = m.group("chr");
                if (chr == null) continue;
                if (chr.equals("{")) {
                    multi = true;
                    continue;
                }
                if (chr.equals("}")) {
                    if (!multi) {
                        stack.pop();
                    }
                    multi = false;
                    chld = false;
                    shib = false;
                    continue;
                }
                if (chr.equals(">")) {
                    multi = false;
                    chld = true;
                    shib = false;
                    continue;
                }
                if (!chr.equals("|")) continue;
                chld = false;
                shib = true;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal in range: " + m.start() + "-" + m.end() + ".", e);
        }
        return first;
    }

    public static void main(String[] args) {
    }
}

