/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.dispatch.url;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.semantic.references.MayNotNull;
import eu.javaexperience.semantic.status.NeedToTest;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.dispatch.url.URLNode;
import eu.javaexperience.web.dispatch.url.URLNodePattern;

@NeedToTest
public class LanguageURLNode
extends URLNode {
    protected final AvailableLanguage default_language;
    protected final AvailableLanguage[] other_languages;
    public ThreadLocal<AvailableLanguage> clientLanguage = new ThreadLocal<AvailableLanguage>(){

        @Override
        protected AvailableLanguage initialValue() {
            return AvailableLanguage.en;
        }
    };

    public LanguageURLNode(AvailableLanguage default_, AvailableLanguage ... otherLanguages) {
        super("");
        this.default_language = default_;
        AssertArgument.assertNotNull((Object)((Object)this.default_language), (String)"default language");
        this.other_languages = otherLanguages;
        AssertArgument.assertNotNull((Object)otherLanguages, (String)"other languages");
        this.pattern = new URLNodePattern(){

            public boolean match(String str) {
                if (LanguageURLNode.this.default_language.isoName.equals(str)) {
                    return true;
                }
                for (AvailableLanguage lang : LanguageURLNode.this.other_languages) {
                    if (!lang.isoName.equals(str)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean match(Context ctx) {
                return this.match(ctx.getRequestUrl().getCurrentURLElement());
            }
        };
    }

    @Override
    public String getNodeName() {
        return this.clientLanguage.get().getISOName();
    }

    public AvailableLanguage getRequestCurrentLanguage() {
        return this.clientLanguage.get();
    }

    @Override
    public boolean dispatch(Context ctx) {
        this.clientLanguage.set(AvailableLanguage.getByISO(ctx.getRequestUrl().getCurrentURLElement()));
        return this.tryDispatchSubNodes(ctx);
    }

    public static enum AvailableLanguage {
        en("en"),
        hu("hu");

        protected final String isoName;

        @MayNotNull
        public static AvailableLanguage getByISO(String iso) {
            for (AvailableLanguage l : AvailableLanguage.values()) {
                if (!l.isoName.equals(iso)) continue;
                return l;
            }
            return en;
        }

        public final String getISOName() {
            return this.isoName;
        }

        private AvailableLanguage(String isoName) {
            this.isoName = isoName;
        }
    }
}

