/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.dispatch.url.spec.compile;

import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.text.StringTools;
import java.io.File;

public class CompilationUnit {
    public static final CompilationUnit[] emptyCompilationUnitArray = new CompilationUnit[0];
    public String dir;
    public String cls;

    public CompilationUnit(String src, String cls) {
        this.dir = src;
        this.cls = cls;
    }

    public CompilationUnit(String src, Class<?> cls) {
        this.dir = src;
        this.cls = cls.getName();
    }

    public File getFile() {
        return this.getUnitFile(this.dir, ".java");
    }

    public File getUnitFile(@MayNull String base, @MayNull String extension) {
        StringBuilder sb = new StringBuilder();
        if (null != base) {
            sb.append(base);
            sb.append("/");
        }
        sb.append(StringTools.replaceAllStrings((String)this.cls, (String)".", (String)"/"));
        if (null != extension) {
            sb.append(extension);
        }
        return new File(sb.toString());
    }

    public void updateTargetModificationDate(String outputDir) {
        this.getUnitFile(outputDir, ".js").setLastModified(this.getFile().lastModified());
    }

    public boolean checkNeedRecompile(String outputDir) {
        File dst = this.getUnitFile(outputDir, ".js");
        if (!dst.exists()) {
            return true;
        }
        File src = this.getFile();
        return src.lastModified() > dst.lastModified();
    }
}

