/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.dispatch.url;

import eu.javaexperience.compress.CompressTools;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public enum ContentCompression {
    gzip{

        @Override
        protected void writeCompressedContent(OutputStream os, byte[] data) throws IOException {
            os.write(CompressTools.compressLZ77((byte[])data));
        }
    }
    ,
    deflate{

        @Override
        protected void writeCompressedContent(OutputStream os, byte[] data) throws IOException {
            os.write(CompressTools.compressZlib((byte[])data, (int)6));
        }
    }
    ,
    identity{

        @Override
        protected void writeCompressedContent(OutputStream os, byte[] data) throws IOException {
            os.write(data);
        }
    };


    public static ContentCompression recognise(HttpServletRequest req) {
        String comp = req.getHeader("Accept-Encoding");
        if (null != comp) {
            try {
                String[] ss;
                for (String s : ss = comp.split(",")) {
                    ContentCompression ret = ContentCompression.valueOf(s.trim());
                    if (null == ret) continue;
                    return ret;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return identity;
    }

    protected abstract void writeCompressedContent(OutputStream var1, byte[] var2) throws IOException;

    public void sendContent(HttpServletResponse resp, byte[] data) throws IOException {
        resp.addHeader("Content-Encoding", this.name());
        ServletOutputStream os = resp.getOutputStream();
        this.writeCompressedContent((OutputStream)os, data);
        os.flush();
    }
}

