/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.dispatch.url;

import eu.javaexperience.web.dispatch.url.URLLink;
import eu.javaexperience.web.dispatch.url.URLNode;
import java.util.List;

public class TldUrlNode
extends URLNode {
    protected String protocol = "http";
    protected int port;

    public TldUrlNode(String name) {
        super(name);
        this.isDomainNode = true;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setProtocol(String proto) {
        this.protocol = proto;
    }

    @Override
    protected String processCanonicalUrl(List<URLLink> nodes) {
        if (this.protocol == null) {
            throw new RuntimeException("No protocol set in TLD Node: " + this.getNodeName());
        }
        URLLink[] lnk = nodes.toArray(URLNode.emptyURLLinkArray);
        String domain = TldUrlNode.getDomain(lnk);
        String path = TldUrlNode.getPath(lnk);
        if (this.port > 0) {
            return this.protocol + "://" + domain + ":" + this.port + path;
        }
        return this.protocol + "://" + domain + path;
    }

    @Override
    public String getCanonicalURL() {
        if (this.protocol == null) {
            throw new RuntimeException("No protocol set in TLD Node: " + this.getNodeName());
        }
        return this.protocol + "://" + this.getNodeName();
    }
}

