/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.dispatch.url.spec;

import eu.javaexperience.arrays.ArrayTools;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.MIME;
import eu.javaexperience.web.dispatch.url.AttachDirectoryURLNode;
import eu.javaexperience.web.dispatch.url.FilesInDirectoryConcaterationUrlNode;
import eu.javaexperience.web.dispatch.url.JavaClassURLNode;
import eu.javaexperience.web.dispatch.url.spec.JsTriggerDirectory;
import java.io.File;
import java.lang.reflect.Method;

public abstract class ScriptpageUrlNode
extends JavaClassURLNode {
    protected FilesInDirectoryConcaterationUrlNode preload;
    protected JsTriggerDirectory jstrigger;
    protected AttachDirectoryURLNode resource;

    @Override
    protected boolean beforeCall(Context ctx, Method m) {
        return true;
    }

    @Override
    protected void afterCall(Context ctx, Method m) {
    }

    @Override
    protected void backward(Context ctx) {
    }

    @Override
    public abstract String getPath();

    public ScriptpageUrlNode(String preloadDir, String jstriggerDir, String resourceDirectory) {
        if (null != preloadDir) {
            this.preload = new FilesInDirectoryConcaterationUrlNode("preload", new File(preloadDir), MIME.javascript.mime);
            this.addChild(this.preload);
        }
        if (null != jstriggerDir) {
            this.jstrigger = new JsTriggerDirectory("jstrigger", new File(jstriggerDir));
            this.addChild(this.jstrigger);
        }
        if (null != resourceDirectory) {
            this.resource = new AttachDirectoryURLNode("repository", resourceDirectory, true);
            this.addChild(this.resource);
        }
    }

    public void setReloadOnRequest(boolean reload) {
        if (null != this.preload) {
            this.preload.setCheckModifiedOnRequest(reload);
        }
        if (null != this.jstrigger) {
            this.jstrigger.setCheckModifiedOnRequest(reload);
        }
    }

    protected abstract void renderPageWith(Context var1, String[] var2, String[] var3);

    @Override
    protected boolean endpoint(Context ctx) {
        Object[] scripts = ctx.getRequest().getParameterValues("script");
        if (null == scripts || 0 == scripts.length || 1 == scripts.length && 0 == scripts[0].length()) {
            scripts = null;
        }
        if (null == scripts || 0 == scripts.length) {
            scripts = new String[]{"js_trigger_opening_page"};
        }
        scripts = (String[])ArrayTools.arrayAppend((Object)"js_trigger_always", (Object[])scripts);
        String path = this.getPath();
        this.renderPageWith(ctx, (String[])scripts, (String[])ArrayTools.withoutNulls((Object[])new String[]{null == this.preload ? null : path + "/preload/" + this.preload.salt.getSalt(), null == this.jstrigger ? null : path + "/jstrigger/" + this.jstrigger.salt.getSalt()}));
        return true;
    }

    @Override
    protected abstract boolean access(Context var1);
}

