/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.dispatch.url.spec.compile;

import eu.javaexperience.io.IOTools;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.web.HttpTools;
import eu.javaexperience.web.MIME;
import eu.javaexperience.web.dispatch.url.CachedSaltedContentUrlNode;
import eu.javaexperience.web.dispatch.url.spec.compile.WebCompiler;
import java.io.File;
import java.io.IOException;

public class CompilerUrlNode
extends CachedSaltedContentUrlNode {
    protected final WebCompiler compiler;
    protected boolean production;
    protected File destinationFile;

    public CompilerUrlNode(String name, File destinationFile, WebCompiler compiler, boolean production) {
        super(name, MIME.javascript.mime);
        this.compiler = compiler;
        this.production = production;
        this.destinationFile = destinationFile;
        this.compiler.setProduction(production);
    }

    public void init() {
        this.refresh();
    }

    @Override
    public CachedSaltedContentUrlNode refresh() {
        this.callbackInvalidate();
        if (!this.production) {
            WebCompiler c = this.getCompiler();
            if (0L == this.destinationFile.lastModified() || c.getSourcesLastModification() != this.destinationFile.lastModified()) {
                c.compile(true);
                c.emitMergedOutput(this.destinationFile.toString());
            }
        }
        this.lastModified = this.determineLastModified();
        this.data = this.transform(this.loadContent());
        this.salt.setName(HttpTools.toCacheSaltHexa(this.lastModified));
        this.callbackRefreshed();
        return this;
    }

    @Override
    public boolean checkModificationRefreshIfNeeded() {
        if (!this.production) {
            this.lastModified = this.destinationFile.lastModified();
            long lastMod = this.determineLastModified();
            if (this.lastModified < lastMod) {
                this.refresh();
                return true;
            }
        }
        return false;
    }

    public WebCompiler getCompiler() {
        return this.compiler;
    }

    protected void assembleFile(File f) throws IOException {
        WebCompiler c = this.getCompiler();
        c.compile(true);
        c.emitMergedOutput(f.toString());
    }

    @Override
    public void callbackInvalidate() {
        if (!this.production) {
            // empty if block
        }
    }

    @Override
    public byte[] loadContent() {
        if (!this.destinationFile.exists()) {
            try {
                this.assembleFile(this.destinationFile);
            }
            catch (IOException e) {
                Mirror.propagateAnyway((Throwable)e);
                return null;
            }
        }
        try {
            return IOTools.loadFileContent((String)this.destinationFile.toString());
        }
        catch (IOException e) {
            Mirror.propagateAnyway((Throwable)e);
            return null;
        }
    }

    @Override
    public long determineLastModified() {
        if (this.production) {
            return this.destinationFile.lastModified();
        }
        return this.getCompiler().getSourcesLastModification();
    }
}

