/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.dispatch;

import eu.javaexperience.dispatch.Dispatcher;
import eu.javaexperience.patterns.behavioral.cor.CorChain;
import eu.javaexperience.patterns.behavioral.cor.CorDispatcher;
import eu.javaexperience.patterns.behavioral.cor.link.CorChainLink;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.dispatch.url.PreparedURL;

public class DefaultDispatchStructure {
    protected static final String[] CHAIN_NAMES = new String[]{"modify", "pre", "static", "system", "app", "last"};
    protected final CorDispatcher<Context> CHAINS = new CorDispatcher();
    protected boolean pathDispatchAdded;
    protected boolean usePathDispatch;

    public DefaultDispatchStructure() {
        CorChain chain = null;
        for (String s : CHAIN_NAMES) {
            CorChain add = new CorChain(s);
            this.CHAINS.addChain(add);
            if (null != chain) {
                chain.setDefaultAction((Dispatcher)add);
            } else {
                this.CHAINS.setRootChain(add);
            }
            chain = add;
        }
        this.pathDispatchAdded = false;
        this.usePathDispatch = false;
    }

    public void setUsePathDispatch(boolean use) {
        if (use && !this.pathDispatchAdded) {
            this.pathDispatchAdded = true;
            this.CHAINS.getChainByName("modify").addLinkAsFirst((CorChainLink)new CorChainLink<Context>(){

                public boolean dispatch(Context ctx) {
                    if (DefaultDispatchStructure.this.usePathDispatch) {
                        PreparedURL url = ctx.getRequestUrl();
                        url.setPathPointer(url.getDomainElements());
                    }
                    return false;
                }
            });
        }
        this.usePathDispatch = use;
    }

    public boolean isUsePathDispatch() {
        return this.usePathDispatch;
    }

    public CorDispatcher<Context> getChains() {
        return this.CHAINS;
    }
}

