/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.sitemap;

import eu.javaexperience.text.Format;
import eu.javaexperience.web.sitemap.SitemapEntry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPOutputStream;

public class SitemapGeneratorTools {
    private static final byte[] C_SITEMAP = "\n\t<sitemap>\n\t".getBytes();
    private static final byte[] C_SITEMAP_END = "\n\t</sitemap>\n".getBytes();
    private static final byte[] SITEMAP_INDEX_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<sitemapindex xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n".getBytes();
    private static final byte[] SITEMAP_INDEX_FOOTER = "</sitemapindex>".getBytes();
    private static final byte[] C_URL = "\t<url>\n".getBytes();
    private static final byte[] C_URL_END = "\t</url>\n".getBytes();
    private static final byte[] C_LOC = "\t\t<loc>".getBytes();
    private static final byte[] C_LOC_END = "</loc>\n".getBytes();
    private static final byte[] C_LASTMOD = "\t\t<lastmod>".getBytes();
    private static final byte[] C_LASTMOD_END = "</lastmod>\n".getBytes();
    private static final byte[] C_IMAGE = "\t\t<image:image>\n".getBytes();
    private static final byte[] C_IMAGE_END = "\t\t</image:image>\n".getBytes();
    private static final byte[] C_IMAGE_LOC = "\t\t\t<image:loc>".getBytes();
    private static final byte[] C_IMAGE_LOC_END = "</image:loc>\n".getBytes();
    public static final Format.DateFormatParseUnit SITEMAP_DATE_FORMAT = new Format.DateFormatParseUnit("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final Set<PosixFilePermission> permission = new HashSet<PosixFilePermission>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(PosixFilePermission.OWNER_READ);
            this.add(PosixFilePermission.OWNER_WRITE);
            this.add(PosixFilePermission.GROUP_READ);
            this.add(PosixFilePermission.OTHERS_READ);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateSiteMapIndex(File dst_file, Collection<SitemapEntry> entries, boolean gz) throws IOException {
        OutputStream os = new FileOutputStream(dst_file);
        try {
            if (gz) {
                os = new GZIPOutputStream(os);
            }
            os.write(SITEMAP_INDEX_HEADER);
            for (SitemapEntry ent : entries) {
                os.write(C_SITEMAP);
                os.write(C_LOC);
                os.write(ent.url.getBytes());
                os.write(C_LOC_END);
                if (null != ent.lastModify) {
                    os.write(C_LASTMOD);
                    os.write(SITEMAP_DATE_FORMAT.format(ent.lastModify).getBytes());
                    os.write(C_LASTMOD_END);
                }
                os.write(C_SITEMAP_END);
            }
            os.write(SITEMAP_INDEX_FOOTER);
        }
        finally {
            os.flush();
            os.close();
        }
    }

    protected static void writeEntry(OutputStream os, SitemapEntry entry) throws IOException {
        os.write(C_URL);
        os.write(C_LOC);
        os.write(entry.url.getBytes());
        os.write(C_LOC_END);
        if (null != entry.lastModify) {
            os.write(C_LASTMOD);
            os.write(SITEMAP_DATE_FORMAT.format(entry.lastModify).getBytes());
            os.write(C_LASTMOD_END);
        }
        if (null != entry.images && !entry.images.isEmpty()) {
            os.write(C_IMAGE);
            for (SitemapEntry img : entry.images) {
                os.write(C_IMAGE_LOC);
                os.write(img.url.getBytes());
                os.write(C_IMAGE_LOC_END);
            }
            os.write(C_IMAGE_END);
        }
        os.write(C_URL_END);
    }

    protected static void writeHeader(OutputStream os) throws IOException {
        os.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<urlset\n\txmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\"\n\txmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\"\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\">\n".getBytes());
    }

    protected static void writeFooter(OutputStream os) throws IOException {
        os.write("</urlset>".getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateSiteMapUrlSet(File dst_file, Collection<SitemapEntry> pages, boolean gz) throws IOException {
        OutputStream os = new FileOutputStream(dst_file);
        try {
            if (gz) {
                os = new GZIPOutputStream(os);
            }
            SitemapGeneratorTools.writeHeader(os);
            for (SitemapEntry page : pages) {
                SitemapGeneratorTools.writeEntry(os, page);
            }
            SitemapGeneratorTools.writeFooter(os);
        }
        finally {
            os.flush();
            os.close();
        }
    }
}

