/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web;

import eu.javaexperience.regex.RegexTools;
import eu.javaexperience.text.StringTools;
import java.util.regex.Pattern;

public class WebTools {
    public static final String EMAIL_REGEX = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    public static final Pattern EMAIL_PATTERN = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
    protected static Pattern SELECT_NON_SEO_CHARS = Pattern.compile("[^a-z0-9-]");
    protected static Pattern SELECT_SEO_CHARS_FOR_DASH = Pattern.compile("[- _]");

    public static boolean isValidEmail(String email) {
        return EMAIL_PATTERN.matcher(email).find();
    }

    public static String asSeoName(String str) {
        str = str.toLowerCase();
        str = StringTools.deAccent((String)str);
        str = RegexTools.MATCH_WHITESPACES.matcher(str).replaceAll(" ");
        str = SELECT_SEO_CHARS_FOR_DASH.matcher(str).replaceAll("-");
        str = SELECT_NON_SEO_CHARS.matcher(str).replaceAll("");
        return str;
    }

    public static void main(String[] args) {
        System.out.println(WebTools.asSeoName("16 db \u00e4rv\u00edzt\u0171r\u0151_t\u00fck\u00f6R-F\u0170R\u0150G\u00e9p"));
    }
}

