/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.dispatch.url;

import eu.javaexperience.file.AbstractFile;
import eu.javaexperience.file.FileSystemTools;
import eu.javaexperience.generic.TimeAttrEntry;
import eu.javaexperience.generic.TimeAttrEntryTools;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.io.IOFunctions;
import eu.javaexperience.web.dispatch.url.ContentConcaterationURLNode;
import java.io.File;
import java.util.ArrayList;

public class FileListConcaterationUrlNode
extends ContentConcaterationURLNode {
    protected AbstractFile[] list;

    public FileListConcaterationUrlNode(String name, String mime) {
        super(name, mime);
        this.list = FileSystemTools.emptyAbstractFileArray;
    }

    public FileListConcaterationUrlNode(String name, String mime, AbstractFile ... files) {
        super(name, mime);
        this.list = files;
    }

    public FileListConcaterationUrlNode(String name, String mime, File ... files) {
        super(name, mime);
        this.list = FileSystemTools.warpFiles((File[])files);
    }

    public void setNewFileList(File ... files) {
        this.list = FileSystemTools.warpFiles((File[])files);
        this.lastModified = 0L;
        this.refresh();
    }

    public void setNewFileList(AbstractFile ... files) {
        this.list = files;
        this.lastModified = 0L;
        this.refresh();
    }

    protected AbstractFile[] getFileList() {
        return this.list;
    }

    @Override
    protected TimeAttrEntry<byte[]>[] getContentList() {
        ArrayList<TimeAttrEntry> ret = new ArrayList<TimeAttrEntry>();
        for (AbstractFile f : this.getFileList()) {
            if (f.isDirectory()) continue;
            ret.add(TimeAttrEntryTools.fromFileWithExaminer((AbstractFile)f, (GetBy1)IOFunctions.LOAD_AFILE_CONTENT));
        }
        return ret.toArray(TimeAttrEntryTools.emptyTimeAttrEntryArray);
    }
}

