/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.dispatch.url;

import eu.javaexperience.semantic.references.MayNotNull;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.dispatch.url.PatternMode;
import eu.javaexperience.web.dispatch.url.URLNodePattern;
import java.util.regex.Pattern;

public class MultiUrlNodePattern
implements URLNodePattern {
    protected String pattern;
    protected int opts = 0;
    @MayNotNull
    protected PatternMode mode;
    protected String originName;
    protected Pattern pat;
    protected String[] strs;

    private MultiUrlNodePattern() {
    }

    @Override
    public boolean match(Context ctx) {
        return this.match(ctx.getRequestUrl().getCurrentURLElement());
    }

    public boolean match(String str) {
        switch (this.mode) {
            case always: {
                return true;
            }
            case regex: {
                return this.pat.matcher(str).find();
            }
            case string: {
                return this.isCaseInsensitive() ? this.pattern.equalsIgnoreCase(str) : this.pattern.equals(str);
            }
            case stringArray: {
                if (this.isCaseInsensitive()) {
                    for (String s : this.strs) {
                        if (!s.equalsIgnoreCase(str)) continue;
                        return true;
                    }
                } else {
                    for (String s : this.strs) {
                        if (!s.equals(str)) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        throw new RuntimeException("URLNodePattern undefined mode case: " + (Object)((Object)this.mode));
    }

    public boolean isCaseInsensitive() {
        return 2 == (this.opts | 2);
    }

    public static MultiUrlNodePattern simpleCaseSensitiveString(String str) {
        MultiUrlNodePattern pat = new MultiUrlNodePattern();
        pat.originName = str;
        pat.mode = PatternMode.string;
        pat.opts = 0;
        pat.pattern = str;
        return pat;
    }

    public static MultiUrlNodePattern simpleCaseInsensitiveString(String str) {
        MultiUrlNodePattern pat = new MultiUrlNodePattern();
        pat.mode = PatternMode.string;
        pat.opts = 2;
        pat.pattern = str;
        return pat;
    }

    public void setOriginName(String name) {
        this.originName = name;
    }

    public String getOriginName() {
        return this.originName;
    }

    public static MultiUrlNodePattern fromRegex(Pattern p) {
        MultiUrlNodePattern ret = new MultiUrlNodePattern();
        ret.mode = PatternMode.regex;
        ret.pattern = p.pattern();
        ret.opts = p.flags();
        ret.pat = p;
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MultiUrlNodePattern)) {
            return false;
        }
        return this.equals((MultiUrlNodePattern)o);
    }

    public boolean equals(MultiUrlNodePattern pat) {
        if (this.mode != pat.mode) {
            return false;
        }
        switch (this.mode) {
            case always: {
                return true;
            }
            case regex: {
                return pat.equals(pat.pat);
            }
            case string: {
                return this.isCaseInsensitive() ? this.pattern.equalsIgnoreCase(pat.pattern) : this.pattern.equals(pat.pattern);
            }
            case stringArray: {
                if (this.isCaseInsensitive()) {
                    block6: for (String s : this.strs) {
                        for (String p : pat.strs) {
                            if (s.equalsIgnoreCase(p)) continue block6;
                        }
                        return false;
                    }
                    return true;
                }
                block8: for (String s : this.strs) {
                    for (String p : pat.strs) {
                        if (s.equals(p)) continue block8;
                    }
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

