/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.web.dispatch.url.spec.compile;

import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.io.file.FileTools;
import eu.javaexperience.struct.BeforeAfterFixture;
import eu.javaexperience.text.StringTools;
import eu.javaexperience.web.dispatch.url.spec.compile.CompilationUnit;
import eu.javaexperience.web.dispatch.url.spec.compile.WebCompiler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractMultiFileWebCompiler
implements WebCompiler {
    public String dstDir;
    public Set<String> sourceDirs = new HashSet<String>();
    public ArrayList<CompilationUnit> clsToCompile = new ArrayList();
    protected Set<String> helperClasses = new HashSet<String>();

    public AbstractMultiFileWebCompiler(String dstDir) {
        this.dstDir = dstDir;
    }

    public void addSourceDirs(String ... dir) {
        CollectionTools.copyInto((Object[])dir, this.sourceDirs);
    }

    public void addClassToCompile(Class<?> cls) {
        for (String src : this.sourceDirs) {
            File f = AbstractMultiFileWebCompiler.toSourceFile(src, cls);
            if (!f.exists()) continue;
            this.clsToCompile.add(new CompilationUnit(src, cls));
            return;
        }
        throw new RuntimeException("Class (" + cls + ") not found in paths: " + CollectionTools.toString(this.sourceDirs));
    }

    public void addClassToCompile(String cls) {
        for (String src : this.sourceDirs) {
            File f = AbstractMultiFileWebCompiler.toSourceFile(src, cls);
            if (!f.exists()) continue;
            this.clsToCompile.add(new CompilationUnit(src, cls));
            return;
        }
        throw new RuntimeException("Class (" + cls + ") not found in paths: " + CollectionTools.toString(this.sourceDirs));
    }

    public void addClassesToCompile(Class<?> ... cls) {
        for (Class<?> c : cls) {
            this.addClassToCompile(c);
        }
    }

    public void addClassesToCompile(String ... cls) {
        for (String c : cls) {
            this.addClassToCompile(c);
        }
    }

    @Override
    public void compile(boolean incremental) {
        new File(this.dstDir).mkdirs();
        ArrayList<File> f = new ArrayList<File>();
        for (String s : this.sourceDirs) {
            f.add(new File(s));
        }
        this.generateAll(this.getCompilationUnits(), this.helperClasses, f, this.dstDir, incremental);
    }

    protected abstract void generateAll(CompilationUnit[] var1, Set<String> var2, ArrayList<File> var3, String var4, boolean var5);

    public static File toSourceFile(String root, Class<?> c) {
        return new File(root + "/" + StringTools.replaceAllStrings((String)c.getName(), (String)".", (String)"/") + ".java");
    }

    public static File toSourceFile(String root, String c) {
        return new File(root + "/" + StringTools.replaceAllStrings((String)c, (String)".", (String)"/") + ".java");
    }

    protected BeforeAfterFixture<File[]> getExtraFileConcatList() {
        return null;
    }

    public void concatOneFile(String dst) throws IOException {
        try (FileOutputStream os = new FileOutputStream(dst);){
            BeforeAfterFixture<File[]> ba = this.getExtraFileConcatList();
            if (null != ba && null != ba.before) {
                for (File f : (File[])ba.before) {
                    if (null == f) continue;
                    IOTools.copyFileContentToStream((File)f, (OutputStream)os);
                }
            }
            for (CompilationUnit cu : this.clsToCompile) {
                IOTools.copyFileContentToStream((File)cu.getUnitFile(this.dstDir, ".js"), (OutputStream)os);
            }
            if (null != ba && null != ba.after) {
                for (File f : (File[])ba.after) {
                    if (null == f) continue;
                    IOTools.copyFileContentToStream((File)f, (OutputStream)os);
                }
            }
            os.flush();
        }
    }

    public CompilationUnit[] getCompilationUnits() {
        return this.clsToCompile.toArray(CompilationUnit.emptyCompilationUnitArray);
    }

    public void cleanupDir() {
        File f = new File(this.dstDir);
        FileTools.deleteDirectory((File)f, (boolean)false);
        f.mkdirs();
    }

    public String getDestinationDir() {
        return this.dstDir;
    }

    public Set<String> getSourceDirs() {
        return new HashSet<String>(this.sourceDirs);
    }

    public void addHelperClassesToCompile(String ... helperClasses) {
        CollectionTools.copyInto((Object[])helperClasses, this.helperClasses);
    }

    public void addHelperClassesToCompile(Class<?> ... helperClasses) {
        for (Class<?> c : helperClasses) {
            this.helperClasses.add(c.getName());
        }
    }

    public Set<String> getHelperClasses() {
        return this.helperClasses;
    }

    @Override
    public long getSourcesLastModification() {
        long t0 = 0L;
        for (CompilationUnit cu : this.getCompilationUnits()) {
            long t = cu.getFile().lastModified();
            if (t <= t0) continue;
            t0 = t;
        }
        return t0;
    }
}

